/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.ing.data.cassandra.jdbc.ByteBufferUtil;
import com.ing.data.cassandra.jdbc.codec.AbstractCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;

public class FloatToDoubleCodec
extends AbstractCodec<Double>
implements TypeCodec<Double> {
    @NonNull
    public GenericType<Double> getJavaType() {
        return GenericType.DOUBLE;
    }

    @NonNull
    public DataType getCqlType() {
        return DataTypes.FLOAT;
    }

    public ByteBuffer encode(Double value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        return ByteBufferUtil.bytes(value.floatValue());
    }

    public Double decode(ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        float value = ByteBufferUtil.toFloat(bytes.duplicate());
        return value;
    }

    @Override
    Double parseNonNull(@NonNull String value) {
        return Double.valueOf(value);
    }

    @Override
    String formatNonNull(@NonNull Double value) {
        return String.valueOf(value);
    }
}

