/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public enum DataTypeEnum {
    ASCII(1, String.class, DataTypeEnum.cqlName(DataTypes.ASCII)),
    BIGINT(2, Long.class, DataTypeEnum.cqlName(DataTypes.BIGINT)),
    BLOB(3, ByteBuffer.class, DataTypeEnum.cqlName(DataTypes.BLOB)),
    BOOLEAN(4, Boolean.class, DataTypeEnum.cqlName(DataTypes.BOOLEAN)),
    COUNTER(5, Long.class, DataTypeEnum.cqlName(DataTypes.COUNTER)),
    CUSTOM(0, ByteBuffer.class, "CUSTOM"),
    DATE(17, Date.class, DataTypeEnum.cqlName(DataTypes.DATE)),
    DECIMAL(6, BigDecimal.class, DataTypeEnum.cqlName(DataTypes.DECIMAL)),
    DOUBLE(7, Double.class, DataTypeEnum.cqlName(DataTypes.DOUBLE)),
    DURATION(21, CqlDuration.class, DataTypeEnum.cqlName(DataTypes.DURATION)),
    FLOAT(8, Float.class, DataTypeEnum.cqlName(DataTypes.FLOAT)),
    INET(16, InetAddress.class, DataTypeEnum.cqlName(DataTypes.INET)),
    INT(9, Integer.class, DataTypeEnum.cqlName(DataTypes.INT)),
    LIST(32, List.class, "list"),
    MAP(33, Map.class, "map"),
    SET(34, Set.class, "set"),
    SMALLINT(19, Short.class, DataTypeEnum.cqlName(DataTypes.SMALLINT)),
    TEXT(13, String.class, DataTypeEnum.cqlName(DataTypes.TEXT)),
    TIME(18, Time.class, DataTypeEnum.cqlName(DataTypes.TIME)),
    TIMESTAMP(11, Timestamp.class, DataTypeEnum.cqlName(DataTypes.TIMESTAMP)),
    TIMEUUID(15, UUID.class, DataTypeEnum.cqlName(DataTypes.TIMEUUID)),
    TINYINT(20, Byte.class, DataTypeEnum.cqlName(DataTypes.TINYINT)),
    TUPLE(49, TupleValue.class, "TUPLE"),
    UDT(48, UdtValue.class, "UDT"),
    UUID(12, UUID.class, DataTypeEnum.cqlName(DataTypes.UUID)),
    VARCHAR(13, String.class, "VARCHAR"),
    VARINT(14, BigInteger.class, DataTypeEnum.cqlName(DataTypes.VARINT));

    private static final Map<String, DataTypeEnum> CQL_DATATYPE_TO_DATATYPE;
    final int protocolId;
    final Class<?> javaType;
    final String cqlType;

    private DataTypeEnum(int protocolId, Class<?> javaType, String cqlType) {
        this.protocolId = protocolId;
        this.javaType = javaType;
        this.cqlType = cqlType;
    }

    static DataTypeEnum fromCqlTypeName(String cqlTypeName) {
        int collectionTypeCharPos = cqlTypeName.indexOf("<");
        String cqlDataType = cqlTypeName;
        if (collectionTypeCharPos > 0) {
            cqlDataType = cqlTypeName.substring(0, collectionTypeCharPos);
        }
        return CQL_DATATYPE_TO_DATATYPE.get(cqlDataType);
    }

    public boolean isCollection() {
        switch (this) {
            case LIST: 
            case SET: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    public Class<?> asJavaClass() {
        return this.javaType;
    }

    public String asLowercaseCql() {
        return this.cqlType.toLowerCase();
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static String cqlName(@NonNull DataType dataType) {
        return dataType.asCql(false, false);
    }

    static {
        CQL_DATATYPE_TO_DATATYPE = Maps.newHashMap();
        for (DataTypeEnum dataType : DataTypeEnum.values()) {
            CQL_DATATYPE_TO_DATATYPE.put(dataType.cqlType, dataType);
        }
    }
}

