/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.ing.data.cassandra.jdbc.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.DataTypeEnum;
import com.ing.data.cassandra.jdbc.TypesMap;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class CassandraParameterMetaData
implements ParameterMetaData {
    private final BoundStatement boundStatement;
    private final int parametersCount;

    public CassandraParameterMetaData(BoundStatement boundStatement, int parametersCount) {
        this.boundStatement = boundStatement;
        this.parametersCount = parametersCount;
    }

    private String getParameterCqlType(int i) {
        return DataTypeEnum.cqlName(this.boundStatement.getType(i - 1));
    }

    private AbstractJdbcType<?> getParameterJdbcType(int i) {
        return TypesMap.getTypeForComparator(this.getParameterCqlType(i).toLowerCase());
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parametersCount;
    }

    @Override
    public int isNullable(int i) {
        return 1;
    }

    @Override
    public boolean isSigned(int i) throws SQLException {
        return this.getParameterJdbcType(i).isSigned();
    }

    @Override
    public int getPrecision(int i) throws SQLException {
        return this.getParameterJdbcType(i).getPrecision(null);
    }

    @Override
    public int getScale(int i) throws SQLException {
        return this.getParameterJdbcType(i).getScale(null);
    }

    @Override
    public int getParameterType(int i) throws SQLException {
        return this.getParameterJdbcType(i).getJdbcType();
    }

    @Override
    public String getParameterTypeName(int i) throws SQLException {
        return this.getParameterCqlType(i);
    }

    @Override
    public String getParameterClassName(int i) throws SQLException {
        return this.getParameterJdbcType(i).getType().getName();
    }

    @Override
    public int getParameterMode(int i) {
        return 1;
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        if (aClass.isAssignableFrom(this.getClass())) {
            return aClass.cast(this);
        }
        throw new SQLFeatureNotSupportedException(String.format("No object was found that matched the provided interface: %s", aClass.getSimpleName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return aClass.isAssignableFrom(this.getClass());
    }
}

