/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.testdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import schemacrawler.testdb.TestSchemaCreator;
import us.fatehi.utility.database.SqlScript;

@CommandLine.Command(description={"Creates a test database schema for testing SchemaCrawler"}, name="Test Schema Creator", mixinStandardHelpOptions=true)
public class TestSchemaCreatorMain
implements Callable<Integer> {
    @CommandLine.Option(names={"--url"}, required=true, description={"JDBC connection URL to the database"}, paramLabel="<url>")
    private String connectionUrl;
    @CommandLine.Option(names={"--user"}, description={"Database user name"}, paramLabel="<user>")
    private String user;
    @CommandLine.Option(names={"--password"}, description={"Database password"}, paramLabel="<password>")
    private String passwordProvided;
    @CommandLine.Option(names={"--scripts-resource"}, description={"Scripts resource on CLASSPATH"}, paramLabel="<scripts-resource>")
    private String scriptsresource;
    @CommandLine.Option(names={"--debug", "-d"}, description={"Debug trace"})
    private boolean debug;

    public static int call(String ... args) {
        int exitCode = new CommandLine((Object)new TestSchemaCreatorMain()).execute(args);
        return exitCode;
    }

    public static void main(String ... args) {
        System.exit(TestSchemaCreatorMain.call(args));
    }

    private TestSchemaCreatorMain() {
    }

    @Override
    public Integer call() {
        try (Connection connection = DriverManager.getConnection(this.connectionUrl, this.user, this.passwordProvided);){
            this.findScriptsResource();
            System.setProperty(SqlScript.class.getCanonicalName() + ".debug", String.valueOf(this.debug));
            TestSchemaCreator testSchemaCreator = new TestSchemaCreator(connection, this.scriptsresource);
            testSchemaCreator.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    private void findScriptsResource() {
        if (this.scriptsresource != null && !this.scriptsresource.isEmpty()) {
            return;
        }
        if (this.connectionUrl == null) {
            throw new IllegalArgumentException("No connection URL provided");
        }
        String[] splitUrl = this.connectionUrl.split(":");
        if (splitUrl.length < 2) {
            throw new IllegalArgumentException("No connection URL provided");
        }
        this.scriptsresource = String.format("/%s.scripts.txt", splitUrl[1]);
    }
}

