/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.xml.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
class OracleWebRowSetXmlReaderContHandler
extends DefaultHandler {
    private OracleWebRowSet wrset;
    private RowSetMetaData rsetMetaData;
    private Vector updatesToRowSet;
    private Vector keyCols;
    private String columnValue;
    private String propertyValue;
    private String metadataValue;
    private boolean isNullValue;
    private int columnIndex;
    private Hashtable propertyNameTagMap;
    private Hashtable metadataNameTagMap;
    private Hashtable dataNameTagMap;
    protected static final String WEBROWSET_ELEMENT_NAME = "webRowSet";
    protected static final String PROPERTIES_ELEMENT_NAME = "properties";
    protected static final String METADATA_ELEMENT_NAME = "metadata";
    protected static final String DATA_ELEMENT_NAME = "data";
    private int state;
    private static final int INITIAL_STATE = 0;
    private static final int PROPERTIES_STATE = 1;
    private static final int METADATA_STATE = 2;
    private static final int DATA_STATE = 3;
    private int tag;
    private static final int NO_TAG = -1;
    private String[] propertyNames;
    private boolean readReadOnlyValue;
    private static final int PROPERTY_COMMAND_TAG = 0;
    private static final int PROPERTY_CONCURRENCY_TAG = 1;
    private static final int PROPERTY_DATASOURCETAG = 2;
    private static final int PROPERTY_ESCAPEPROCESSING_TAG = 3;
    private static final int PROPERTY_FETCHDIRECTION_TAG = 4;
    private static final int PROPERTY_FETCHSIZE_TAG = 5;
    private static final int PROPERTY_ISOLATIONLEVEL_TAG = 6;
    private static final int PROPERTY_KEYCOLUMNS_TAG = 7;
    private static final int PROPERTY_MAP_TAG = 8;
    private static final int PROPERTY_MAXFIELDSIZE_TAG = 9;
    private static final int PROPERTY_MAXROWS_TAG = 10;
    private static final int PROPERTY_QUERYTIMEOUT_TAG = 11;
    private static final int PROPERTY_READONLY_TAG = 12;
    private static final int PROPERTY_ROWSETTYPE_TAG = 13;
    private static final int PROPERTY_SHOWDELETED_TAG = 14;
    private static final int PROPERTY_TABLENAME_TAG = 15;
    private static final int PROPERTY_URL_TAG = 16;
    private static final int PROPERTY_SYNCPROVIDER_TAG = 17;
    private static final int PROPERTY_NULL_TAG = 18;
    private static final int PROPERTY_COLUMN_TAG = 19;
    private static final int PROPERTY_TYPE_TAG = 20;
    private static final int PROPERTY_CLASS_TAG = 21;
    private static final int PROPERTY_SYNCPROVIDERNAME_TAG = 22;
    private static final int PROPERTY_SYNCPROVIDERVENDOR_TAG = 23;
    private static final int PROPERTY_SYNCPROVIDERVERSION_TAG = 24;
    private static final int PROPERTY_SYNCPROVIDERGRADE_TAG = 25;
    private static final int PROPERTY_DATASOURCELOCK_TAG = 26;
    private String[] metadataNames;
    private static final int METADATA_COLUMNCOUNT_TAG = 0;
    private static final int METADATA_COLUMNDEFINITION_TAG = 1;
    private static final int METADATA_COLUMNINDEX_TAG = 2;
    private static final int METADATA_AUTOINCREMENT_TAG = 3;
    private static final int METADATA_CASESENSITIVE_TAG = 4;
    private static final int METADATA_CURRENCY_TAG = 5;
    private static final int METADATA_NULLABLE_TAG = 6;
    private static final int METADATA_SIGNED_TAG = 7;
    private static final int METADATA_SEARCHABLE_TAG = 8;
    private static final int METADATA_COLUMNDISPLAYSIZE_TAG = 9;
    private static final int METADATA_COLUMNLABEL_TAG = 10;
    private static final int METADATA_COLUMNNAME_TAG = 11;
    private static final int METADATA_SCHEMANAME_TAG = 12;
    private static final int METADATA_COLUMNPRECISION_TAG = 13;
    private static final int METADATA_COLUMNSCALE_TAG = 14;
    private static final int METADATA_TABLENAME_TAG = 15;
    private static final int METADATA_CATALOGNAME_TAG = 16;
    private static final int METADATA_COLUMNTYPE_TAG = 17;
    private static final int METADATA_COLUMNTYPENAME_TAG = 18;
    private static final int METADATA_NULL_TAG = 19;
    private String[] dataNames;
    private static final int DATA_CURRENTROW_TAG = 0;
    private static final int DATA_INSERTROW_TAG = 1;
    private static final int DATA_DELETEROW_TAG = 2;
    private static final int DATA_MODIFYROW_TAG = 3;
    private static final int DATA_COLUMNVALUE_TAG = 4;
    private static final int DATA_UPDATEVALUE_TAG = 5;
    private static final int DATA_NULL_TAG = 6;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;

    OracleWebRowSetXmlReaderContHandler(RowSet rowset) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$35, null, rowset);
            }
            this.propertyNames = new String[]{"command", "concurrency", "datasource", "escape-processing", "fetch-direction", "fetch-size", "isolation-level", "key-columns", "map", "max-field-size", "max-rows", "query-timeout", "read-only", "rowset-type", "show-deleted", "table-name", "url", "sync-provider", "null", "column", "type", "class", "sync-provider-name", "sync-provider-vendor", "sync-provider-version", "sync-provider-grade", "data-source-lock"};
            this.metadataNames = new String[]{"column-count", "column-definition", "column-index", "auto-increment", "case-sensitive", "currency", "nullable", "signed", "searchable", "column-display-size", "column-label", "column-name", "schema-name", "column-precision", "column-scale", "table-name", "catalog-name", "column-type", "column-type-name", "null"};
            this.dataNames = new String[]{"currentRow", "insertRow", "deleteRow", "modifyRow", "columnValue", "updateValue", "null"};
            this.wrset = (OracleWebRowSet)rowset;
            this.initialize();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$35, null);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$35, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void start;
            void chrs;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$0, this, cArray, n2, n3);
            }
            String elementValue = new String((char[])chrs, (int)start, (int)length);
            this.processElement(elementValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$1, this, new Object[0]);
            }
            try {
                if (this.readReadOnlyValue) {
                    this.wrset.setReadOnly(this.readReadOnlyValue);
                }
            }
            catch (SQLException sqlexc) {
                SAXException sAXException = new SAXException(sqlexc.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$1, this, sAXException);
                }
                throw sAXException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void qualifiedName;
            void localName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, string, string2, string3);
            }
            void elementName = localName == null || localName.equals("") ? qualifiedName : localName;
            block9 : switch (this.getState()) {
                case 1: {
                    if (elementName.equals(PROPERTIES_ELEMENT_NAME)) {
                        this.state = 0;
                        break;
                    }
                    try {
                        int pTag = (Integer)this.propertyNameTagMap.get(elementName);
                        switch (pTag) {
                            case 7: {
                                if (this.keyCols == null) break;
                                int[] keyColumns = new int[this.keyCols.size()];
                                for (int i2 = 0; i2 < keyColumns.length; ++i2) {
                                    keyColumns[i2] = Integer.parseInt((String)this.keyCols.elementAt(i2));
                                }
                                this.wrset.setKeyColumns(keyColumns);
                            }
                        }
                        this.setPropertyValue(this.propertyValue);
                    }
                    catch (SQLException sqlexc) {
                        SAXException sAXException = new SAXException(sqlexc.getMessage());
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, sAXException);
                        }
                        throw sAXException;
                    }
                    this.propertyValue = "";
                    this.setNullValue(false);
                    this.setTag(-1);
                    break;
                }
                case 2: {
                    if (elementName.equals(METADATA_ELEMENT_NAME)) {
                        try {
                            this.wrset.setMetaData(this.rsetMetaData);
                            this.state = 0;
                            break;
                        }
                        catch (SQLException sqlexc) {
                            SAXException sAXException = new SAXException("Error setting metadata in WebRowSet: " + sqlexc.getMessage());
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, sAXException);
                            }
                            throw sAXException;
                        }
                    }
                    try {
                        this.setMetaDataValue(this.metadataValue);
                    }
                    catch (SQLException sqlexc) {
                        SAXException sAXException = new SAXException("Error setting metadata value: " + sqlexc.getMessage());
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, sAXException);
                        }
                        throw sAXException;
                    }
                    this.metadataValue = "";
                    this.setNullValue(false);
                    this.setTag(-1);
                    break;
                }
                case 3: {
                    if (elementName.equals(DATA_ELEMENT_NAME)) {
                        this.state = 0;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this);
                            ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, null);
                        }
                        return;
                    }
                    int dTag = (Integer)this.dataNameTagMap.get(elementName);
                    switch (dTag) {
                        default: {
                            break block9;
                        }
                        case 4: {
                            try {
                                ++this.columnIndex;
                                this.insertValue(this.columnValue);
                                this.columnValue = "";
                                this.setNullValue(false);
                                this.setTag(-1);
                                break block9;
                            }
                            catch (SQLException sqlexc) {
                                SAXException sAXException = new SAXException("Error inserting column values: " + sqlexc.getMessage());
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, sAXException);
                                }
                                throw sAXException;
                            }
                        }
                        case 0: {
                            try {
                                this.wrset.insertRow();
                                this.wrset.moveToCurrentRow();
                                this.wrset.next();
                                OracleRow row = this.wrset.getCurrentRow();
                                row.setInsertedFlag(false);
                                this.applyUpdates();
                                break block9;
                            }
                            catch (SQLException sqlexc) {
                                SAXException sAXException = new SAXException("Error constructing current row: " + sqlexc.getMessage());
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, sAXException);
                                }
                                throw sAXException;
                            }
                        }
                        case 2: {
                            try {
                                this.wrset.insertRow();
                                this.wrset.moveToCurrentRow();
                                this.wrset.next();
                                OracleRow row = this.wrset.getCurrentRow();
                                row.setInsertedFlag(false);
                                row.setRowDeleted(true);
                                this.applyUpdates();
                                break block9;
                            }
                            catch (SQLException sqlexc) {
                                SAXException sAXException = new SAXException("Error constructing deleted row: " + sqlexc.getMessage());
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, sAXException);
                                }
                                throw sAXException;
                            }
                        }
                        case 1: {
                            try {
                                this.wrset.insertRow();
                                this.wrset.moveToCurrentRow();
                                this.wrset.next();
                                this.applyUpdates();
                                break block9;
                            }
                            catch (SQLException sqlexc) {
                                SAXException sAXException = new SAXException("Error constructing inserted row: " + sqlexc.getMessage());
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, sAXException);
                                }
                                throw sAXException;
                            }
                        }
                        case 3: 
                    }
                    try {
                        this.wrset.insertRow();
                        this.wrset.moveToCurrentRow();
                        this.wrset.next();
                        OracleRow row = this.wrset.getCurrentRow();
                        row.setRowDeleted(true);
                        this.applyUpdates();
                        break;
                    }
                    catch (SQLException sqlexc) {
                        SAXException sAXException = new SAXException("Error constructing modified row: " + sqlexc.getMessage());
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, sAXException);
                        }
                        throw sAXException;
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void qualifiedName;
            void localName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$3, this, string, string2, string3, attributes);
            }
            void elementName = localName == null || localName.equals("") ? qualifiedName : localName;
            switch (this.getState()) {
                case 1: {
                    int pTag = (Integer)this.propertyNameTagMap.get(elementName);
                    if (pTag == 18) {
                        this.setNullValue(true);
                        this.propertyValue = null;
                        break;
                    }
                    this.setTag(pTag);
                    break;
                }
                case 2: {
                    int mTag = (Integer)this.metadataNameTagMap.get(elementName);
                    if (mTag == 19) {
                        this.setNullValue(true);
                        this.metadataValue = null;
                        break;
                    }
                    this.setTag(mTag);
                    break;
                }
                case 3: {
                    int dTag = (Integer)this.dataNameTagMap.get(elementName);
                    if (dTag == 6) {
                        this.setNullValue(true);
                        this.columnValue = null;
                        break;
                    }
                    this.setTag(dTag);
                    if (dTag != 0 && dTag != 1 && dTag != 2 && dTag != 3) break;
                    this.columnIndex = 0;
                    try {
                        this.wrset.moveToInsertRow();
                    }
                    catch (SQLException sQLException) {}
                    break;
                }
                default: {
                    this.setState((String)elementName);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void saxparseexception;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$4, this, sAXParseException);
            }
            void var3_3 = saxparseexception;
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$4, this, (Throwable)var3_3);
            }
            throw var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void saxparseexception;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$5, this, sAXParseException);
            }
            System.out.println("** Warning, line " + saxparseexception.getLineNumber() + ", uri " + saxparseexception.getSystemId());
            System.out.println("   " + saxparseexception.getMessage());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    private void initialize() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            int j2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$6, this, new Object[0]);
            }
            this.propertyNameTagMap = new Hashtable(30);
            int i2 = this.propertyNames.length;
            for (j2 = 0; j2 < i2; ++j2) {
                this.propertyNameTagMap.put(this.propertyNames[j2], j2);
            }
            this.metadataNameTagMap = new Hashtable(30);
            i2 = this.metadataNames.length;
            for (j2 = 0; j2 < i2; ++j2) {
                this.metadataNameTagMap.put(this.metadataNames[j2], j2);
            }
            this.dataNameTagMap = new Hashtable(10);
            i2 = this.dataNames.length;
            for (j2 = 0; j2 < i2; ++j2) {
                this.dataNameTagMap.put(this.dataNames[j2], j2);
            }
            this.updatesToRowSet = new Vector();
            this.columnValue = "";
            this.propertyValue = "";
            this.metadataValue = "";
            this.isNullValue = false;
            this.columnIndex = 0;
            this.readReadOnlyValue = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void processElement(String string) throws SAXException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$7, this, string);
            }
            try {
                switch (this.getState()) {
                    case 1: {
                        void elementValue;
                        this.propertyValue = elementValue;
                        break;
                    }
                    case 2: {
                        void elementValue;
                        this.metadataValue = elementValue;
                        break;
                    }
                    case 3: {
                        void elementValue;
                        this.setDataValue((String)elementValue);
                    }
                }
            }
            catch (SQLException sqlexc) {
                SAXException sAXException = new SAXException("processElement: " + sqlexc.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$7, this, sAXException);
                }
                throw sAXException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private BigDecimal getBigDecimalValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$8, this, string);
            }
            BigDecimal bigDecimal = new BigDecimal((String)colValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$8, this, bigDecimal);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$8, this, null);
            }
            return bigDecimal;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBinaryValue(String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            byte[] ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$9, this, string);
            }
            byte[] byArray = ret = XMLUtil.parseBase64Binary((String)colValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$9, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$9, this, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean getBooleanValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$10, this, string);
            }
            boolean bl2 = Boolean.valueOf((String)colValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$10, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$10, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte getByteValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$11, this, string);
            }
            byte by = Byte.parseByte((String)colValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$11, this, by);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$11, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Date getDateValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$12, this, string);
            }
            Date date = new Date(this.getLongValue((String)colValue));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$12, this, date);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$12, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private double getDoubleValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$13, this, string);
            }
            double d2 = Double.parseDouble((String)colValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$13, this, d2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$13, this, null);
            }
            return d2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private float getFloatValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$14, this, string);
            }
            float f2 = Float.parseFloat((String)colValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$14, this, Float.valueOf(f2));
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$14, this, null);
            }
            return f2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getIntegerValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$15, this, string);
            }
            int n2 = Integer.parseInt((String)colValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$15, this, n2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$15, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private long getLongValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$16, this, string);
            }
            long l2 = Long.parseLong((String)colValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$16, this, l2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$16, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    private boolean getNullValue() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$17, this, new Object[0]);
            }
            boolean bl2 = this.isNullValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$17, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$17, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private short getShortValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$18, this, string);
            }
            short s2 = Short.parseShort((String)colValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$18, this, s2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$18, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getStringValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$19, this, string);
            }
            void var3_3 = colValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$19, this, var3_3);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$19, this, null);
            }
            return var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Time getTimeValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$20, this, string);
            }
            Time time = new Time(this.getLongValue((String)colValue));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$20, this, time);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$20, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Timestamp getTimestampValue(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$21, this, string);
            }
            Timestamp timestamp = new Timestamp(this.getLongValue((String)colValue));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$21, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$21, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Blob getBlobValue(String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$22, this, string);
            }
            byte[] ret = XMLUtil.parseBase64Binary((String)colValue);
            OracleSerialBlob oracleSerialBlob = new OracleSerialBlob(ret);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$22, this, oracleSerialBlob);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$22, this, null);
            }
            return oracleSerialBlob;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Clob getClobValue(String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$23, this, string);
            }
            OracleSerialClob oracleSerialClob = new OracleSerialClob(colValue.toCharArray());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$23, this, oracleSerialClob);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$23, this, null);
            }
            return oracleSerialClob;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    private void applyUpdates() throws SAXException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$24, this, new Object[0]);
            }
            if (this.updatesToRowSet.size() > 0) {
                try {
                    for (Object[] update : this.updatesToRowSet) {
                        this.columnIndex = (Integer)update[0];
                        this.insertValue((String)update[1]);
                    }
                    this.wrset.updateRow();
                }
                catch (SQLException sqlexc) {
                    SAXException sAXException = new SAXException("Error updating row: " + sqlexc.getMessage());
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$24, this, sAXException);
                    }
                    throw sAXException;
                }
                this.updatesToRowSet.removeAllElements();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void insertValue(String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void colValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$25, this, string);
            }
            if (this.getNullValue() || colValue == null) {
                this.wrset.updateNull(this.columnIndex);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$25, this);
                    ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$25, this, null);
                }
                return;
            }
            int colType = this.wrset.getMetaData().getColumnType(this.columnIndex);
            switch (colType) {
                case -7: {
                    this.wrset.updateByte(this.columnIndex, this.getByteValue((String)colValue));
                    break;
                }
                case 5: {
                    this.wrset.updateShort(this.columnIndex, this.getShortValue((String)colValue));
                    break;
                }
                case 4: {
                    this.wrset.updateInt(this.columnIndex, this.getIntegerValue((String)colValue));
                    break;
                }
                case -5: {
                    this.wrset.updateLong(this.columnIndex, this.getLongValue((String)colValue));
                    break;
                }
                case 6: 
                case 7: {
                    this.wrset.updateFloat(this.columnIndex, this.getFloatValue((String)colValue));
                    break;
                }
                case 8: {
                    this.wrset.updateDouble(this.columnIndex, this.getDoubleValue((String)colValue));
                    break;
                }
                case 2: 
                case 3: {
                    this.wrset.updateObject(this.columnIndex, (Object)this.getBigDecimalValue((String)colValue));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.wrset.updateBytes(this.columnIndex, this.getBinaryValue((String)colValue));
                    break;
                }
                case 91: {
                    this.wrset.updateDate(this.columnIndex, this.getDateValue((String)colValue));
                    break;
                }
                case 92: {
                    this.wrset.updateTime(this.columnIndex, this.getTimeValue((String)colValue));
                    break;
                }
                case 93: {
                    this.wrset.updateTimestamp(this.columnIndex, this.getTimestampValue((String)colValue));
                    break;
                }
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    this.wrset.updateString(this.columnIndex, this.getStringValue((String)colValue));
                    break;
                }
                case 2004: {
                    this.wrset.updateBlob(this.columnIndex, this.getBlobValue((String)colValue));
                    break;
                }
                case 2005: {
                    this.wrset.updateClob(this.columnIndex, this.getClobValue((String)colValue));
                    break;
                }
                case 2011: {
                    this.wrset.updateNClob(this.columnIndex, (NClob)this.getClobValue((String)colValue));
                    break;
                }
                default: {
                    SQLException sQLException = new SQLException("The type " + colType + " is not supported currently.");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$25, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setPropertyValue(String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, string);
            }
            boolean flag = this.getNullValue();
            switch (this.getTag()) {
                default: {
                    break;
                }
                case 0: {
                    void propValue;
                    if (flag) {
                        this.wrset.setCommand(null);
                        break;
                    }
                    this.wrset.setCommand((String)propValue);
                    break;
                }
                case 1: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.wrset.setConcurrency(this.getIntegerValue((String)propValue));
                    break;
                }
                case 2: {
                    void propValue;
                    if (flag) {
                        this.wrset.setDataSourceName(null);
                        break;
                    }
                    this.wrset.setDataSourceName((String)propValue);
                    break;
                }
                case 3: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.wrset.setEscapeProcessing(this.getBooleanValue((String)propValue));
                    break;
                }
                case 4: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    int _rsetType = this.wrset.getType();
                    if (_rsetType == 1005) break;
                    this.wrset.setFetchDirection(this.getIntegerValue((String)propValue));
                    break;
                }
                case 5: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.wrset.setFetchSize(this.getIntegerValue((String)propValue));
                    break;
                }
                case 6: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.wrset.setTransactionIsolation(this.getIntegerValue((String)propValue));
                    break;
                }
                case 19: {
                    void propValue;
                    if (this.keyCols == null) {
                        this.keyCols = new Vector();
                    }
                    this.keyCols.add(propValue);
                    break;
                }
                case 9: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.wrset.setMaxFieldSize(this.getIntegerValue((String)propValue));
                    break;
                }
                case 10: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.wrset.setMaxRows(this.getIntegerValue((String)propValue));
                    break;
                }
                case 11: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.wrset.setQueryTimeout(this.getIntegerValue((String)propValue));
                    break;
                }
                case 12: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.readReadOnlyValue = this.getBooleanValue((String)propValue);
                    break;
                }
                case 13: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.wrset.setType(this.getIntegerValue((String)propValue));
                    break;
                }
                case 14: {
                    void propValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.wrset.setShowDeleted(this.getBooleanValue((String)propValue));
                    break;
                }
                case 15: {
                    void propValue;
                    if (flag) {
                        this.wrset.setTableName(null);
                        break;
                    }
                    this.wrset.setTableName((String)propValue);
                    break;
                }
                case 16: {
                    void propValue;
                    if (flag) {
                        this.wrset.setUrl(null);
                        break;
                    }
                    this.wrset.setUrl((String)propValue);
                    break;
                }
                case 22: {
                    void propValue;
                    if (flag) {
                        this.wrset.setSyncProvider(null);
                        break;
                    }
                    this.wrset.setSyncProvider((String)propValue);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setMetaDataValue(String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, string);
            }
            boolean flag = this.getNullValue();
            switch (this.getTag()) {
                default: {
                    break;
                }
                case 0: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    int _columnCount = this.getIntegerValue((String)metaValue);
                    this.rsetMetaData = new OracleRowSetMetaData(_columnCount);
                    this.columnIndex = 0;
                    break;
                }
                case 2: {
                    ++this.columnIndex;
                    break;
                }
                case 3: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.rsetMetaData.setAutoIncrement(this.columnIndex, this.getBooleanValue((String)metaValue));
                    break;
                }
                case 4: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.rsetMetaData.setCaseSensitive(this.columnIndex, this.getBooleanValue((String)metaValue));
                    break;
                }
                case 5: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.rsetMetaData.setCurrency(this.columnIndex, this.getBooleanValue((String)metaValue));
                    break;
                }
                case 6: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.rsetMetaData.setNullable(this.columnIndex, this.getIntegerValue((String)metaValue));
                    break;
                }
                case 7: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.rsetMetaData.setSigned(this.columnIndex, this.getBooleanValue((String)metaValue));
                    break;
                }
                case 8: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.rsetMetaData.setSearchable(this.columnIndex, this.getBooleanValue((String)metaValue));
                    break;
                }
                case 9: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.rsetMetaData.setColumnDisplaySize(this.columnIndex, this.getIntegerValue((String)metaValue));
                    break;
                }
                case 10: {
                    void metaValue;
                    if (flag) {
                        this.rsetMetaData.setColumnLabel(this.columnIndex, null);
                        break;
                    }
                    this.rsetMetaData.setColumnLabel(this.columnIndex, (String)metaValue);
                    break;
                }
                case 11: {
                    void metaValue;
                    if (flag) {
                        this.rsetMetaData.setColumnName(this.columnIndex, null);
                        break;
                    }
                    this.rsetMetaData.setColumnName(this.columnIndex, (String)metaValue);
                    break;
                }
                case 12: {
                    void metaValue;
                    if (flag) {
                        this.rsetMetaData.setSchemaName(this.columnIndex, null);
                        break;
                    }
                    this.rsetMetaData.setSchemaName(this.columnIndex, (String)metaValue);
                    break;
                }
                case 13: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.rsetMetaData.setPrecision(this.columnIndex, this.getIntegerValue((String)metaValue));
                    break;
                }
                case 14: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.rsetMetaData.setScale(this.columnIndex, this.getIntegerValue((String)metaValue));
                    break;
                }
                case 15: {
                    void metaValue;
                    if (flag) {
                        this.rsetMetaData.setTableName(this.columnIndex, null);
                        break;
                    }
                    this.rsetMetaData.setTableName(this.columnIndex, (String)metaValue);
                    break;
                }
                case 16: {
                    void metaValue;
                    if (flag) {
                        this.rsetMetaData.setCatalogName(this.columnIndex, null);
                        break;
                    }
                    this.rsetMetaData.setCatalogName(this.columnIndex, (String)metaValue);
                    break;
                }
                case 17: {
                    void metaValue;
                    if (flag) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.rsetMetaData.setColumnType(this.columnIndex, this.getIntegerValue((String)metaValue));
                    break;
                }
                case 18: {
                    void metaValue;
                    if (flag) {
                        this.rsetMetaData.setColumnTypeName(this.columnIndex, null);
                        break;
                    }
                    this.rsetMetaData.setColumnTypeName(this.columnIndex, (String)metaValue);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setDataValue(String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$28, this, string);
            }
            switch (this.getTag()) {
                default: {
                    break;
                }
                case 4: {
                    void elementValue;
                    this.columnValue = elementValue;
                    break;
                }
                case 5: {
                    void elementValue;
                    Object[] update = new Object[2];
                    update[1] = elementValue;
                    update[0] = this.columnIndex;
                    this.updatesToRowSet.add(update);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setNullValue(boolean bl) {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void flag;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$29, this, bl);
            }
            this.isNullValue = flag;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    private int getState() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$30, this, new Object[0]);
            }
            int n2 = this.state;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$30, this, n2);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$30, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    private int getTag() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$31, this, new Object[0]);
            }
            int n2 = this.tag;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$31, this, n2);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$31, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setState(String string) throws SAXException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void elementName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$32, this, string);
            }
            if (elementName.equals(WEBROWSET_ELEMENT_NAME)) {
                this.state = 0;
            } else if (elementName.equals(PROPERTIES_ELEMENT_NAME)) {
                this.state = this.state != 1 ? 1 : 0;
            } else if (elementName.equals(METADATA_ELEMENT_NAME)) {
                this.state = this.state != 2 ? 2 : 0;
            } else if (elementName.equals(DATA_ELEMENT_NAME)) {
                this.state = this.state != 3 ? 3 : 0;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setTag(int n2) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void t2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$33, this, n2);
            }
            this.tag = t2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$34, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$34, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$34, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleWebRowSetXmlReaderContHandler.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$35 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredConstructor(RowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setTag", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setState", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getTag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setNullValue", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setDataValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setMetaDataValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setPropertyValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("insertValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("applyUpdates", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getClobValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getBlobValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getTimestampValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getTimeValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getStringValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getShortValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getNullValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getLongValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getIntegerValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getFloatValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getDoubleValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getDateValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getByteValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getBooleanValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getBinaryValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getBigDecimalValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("processElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("initialize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("warning", SAXParseException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("error", SAXParseException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("endDocument", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("characters", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

