/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.duckdb.DuckDBNative;

public class DuckDBDatabase {
    public static final String DEFAULT_SCHEMA = "main";
    protected String url;
    protected boolean read_only;
    private AtomicInteger connections;
    protected ByteBuffer db_ref;

    public DuckDBDatabase(String string, boolean bl, Properties properties) throws SQLException {
        if (!string.startsWith("jdbc:duckdb")) {
            throw new SQLException("DuckDB JDBC URL needs to start with 'jdbc:duckdb:'");
        }
        this.url = string;
        String string2 = string.replaceFirst("^jdbc:duckdb:", "").trim();
        if (string2.length() == 0) {
            string2 = ":memory:";
        }
        this.read_only = bl;
        this.db_ref = DuckDBNative.duckdb_jdbc_startup(string2.getBytes(StandardCharsets.UTF_8), bl, properties);
        this.connections = new AtomicInteger();
    }

    public void shutdown() {
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected synchronized void finalize() throws Throwable {
        if (this.db_ref != null) {
            DuckDBNative.duckdb_jdbc_shutdown(this.db_ref);
            this.db_ref = null;
        }
    }

    void incrementConnections() {
        this.connections.incrementAndGet();
    }

    void maybeShutdown() {
        if (this.connections.decrementAndGet() == 0) {
            this.shutdown();
        }
    }

    public boolean isShutdown() {
        return this.db_ref == null;
    }
}

