/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firebirdsql.gds.ng.AbstractAttachProperties;
import org.firebirdsql.gds.ng.FbImmutableConnectionProperties;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.props.internal.ConnectionPropertyRegistry;

public final class FbConnectionProperties
extends AbstractAttachProperties<IConnectionProperties>
implements IConnectionProperties,
Serializable {
    private static final Pattern GMT_WITH_OFFSET = Pattern.compile("^GMT([+-]\\d{2}:\\d{2})$");
    private FbImmutableConnectionProperties immutableConnectionPropertiesCache;

    public FbConnectionProperties(IConnectionProperties src) {
        super(src);
    }

    public FbConnectionProperties() {
        this.setSessionTimeZone(FbConnectionProperties.defaultTimeZone());
        this.setSqlDialect(3);
    }

    private FbConnectionProperties(HashMap<ConnectionProperty, Object> propValues) {
        super(propValues);
    }

    @Override
    public IConnectionProperties asImmutable() {
        if (this.immutableConnectionPropertiesCache == null) {
            this.immutableConnectionPropertiesCache = new FbImmutableConnectionProperties(this);
        }
        return this.immutableConnectionPropertiesCache;
    }

    @Override
    public IConnectionProperties asNewMutable() {
        return new FbConnectionProperties(this);
    }

    @Override
    protected Object resolveStoredDefaultValue(ConnectionProperty property) {
        switch (property.name()) {
            case "sessionTimeZone": {
                return FbConnectionProperties.defaultTimeZone();
            }
            case "sqlDialect": {
                return 3;
            }
        }
        return super.resolveStoredDefaultValue(property);
    }

    private static String defaultTimeZone() {
        Matcher matcher;
        String timeZone = TimeZone.getDefault().getID();
        if (timeZone.startsWith("GMT") && timeZone.length() > 3 && (matcher = GMT_WITH_OFFSET.matcher(timeZone)).matches()) {
            return matcher.group(1);
        }
        return timeZone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected void dirtied() {
        this.immutableConnectionPropertiesCache = null;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, Serializable> propValues;

        private SerializationProxy(FbConnectionProperties fbConnectionProperties) {
            Map<ConnectionProperty, Object> srcProps = fbConnectionProperties.connectionPropertyValues();
            this.propValues = new HashMap<String, Serializable>(srcProps.size());
            srcProps.forEach((k, v) -> this.propValues.put(k.name(), (Serializable)v));
        }

        protected Object readResolve() {
            HashMap targetProps = new HashMap(this.propValues.size());
            ConnectionPropertyRegistry propertyRegistry = ConnectionPropertyRegistry.getInstance();
            this.propValues.forEach((k, v) -> targetProps.put(propertyRegistry.getOrUnknown((String)k), v));
            return new FbConnectionProperties(targetProps);
        }
    }
}

