/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.model.MLModelConfig;

public class TextEmbeddingModelConfig
extends MLModelConfig {
    public static final String PARSE_FIELD_NAME = FunctionName.TEXT_EMBEDDING.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(TextEmbeddingModelConfig.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> TextEmbeddingModelConfig.parse(it));
    public static final String EMBEDDING_DIMENSION_FIELD = "embedding_dimension";
    public static final String FRAMEWORK_TYPE_FIELD = "framework_type";
    public static final String POOLING_MODE_FIELD = "pooling_mode";
    public static final String NORMALIZE_RESULT_FIELD = "normalize_result";
    public static final String MODEL_MAX_LENGTH_FIELD = "model_max_length";
    private final Integer embeddingDimension;
    private final FrameworkType frameworkType;
    private final PoolingMode poolingMode;
    private final boolean normalizeResult;
    private final Integer modelMaxLength;

    public TextEmbeddingModelConfig(String modelType, Integer embeddingDimension, FrameworkType frameworkType, String allConfig, PoolingMode poolingMode, boolean normalizeResult, Integer modelMaxLength) {
        super(modelType, allConfig);
        if (embeddingDimension == null) {
            throw new IllegalArgumentException("embedding dimension is null");
        }
        if (frameworkType == null) {
            throw new IllegalArgumentException("framework type is null");
        }
        this.embeddingDimension = embeddingDimension;
        this.frameworkType = frameworkType;
        this.poolingMode = poolingMode;
        this.normalizeResult = normalizeResult;
        this.modelMaxLength = modelMaxLength;
    }

    public static TextEmbeddingModelConfig parse(XContentParser parser) throws IOException {
        String modelType = null;
        Integer embeddingDimension = null;
        FrameworkType frameworkType = null;
        String allConfig = null;
        PoolingMode poolingMode = null;
        boolean normalizeResult = false;
        Integer modelMaxLength = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_type": {
                    modelType = parser.text();
                    continue block18;
                }
                case "embedding_dimension": {
                    embeddingDimension = parser.intValue();
                    continue block18;
                }
                case "framework_type": {
                    frameworkType = FrameworkType.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block18;
                }
                case "all_config": {
                    allConfig = parser.text();
                    continue block18;
                }
                case "pooling_mode": {
                    poolingMode = PoolingMode.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block18;
                }
                case "normalize_result": {
                    normalizeResult = parser.booleanValue();
                    continue block18;
                }
                case "model_max_length": {
                    modelMaxLength = parser.intValue();
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return new TextEmbeddingModelConfig(modelType, embeddingDimension, frameworkType, allConfig, poolingMode, normalizeResult, modelMaxLength);
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public TextEmbeddingModelConfig(StreamInput in) throws IOException {
        super(in);
        this.embeddingDimension = in.readInt();
        this.frameworkType = (FrameworkType)in.readEnum(FrameworkType.class);
        this.poolingMode = in.readBoolean() ? (PoolingMode)in.readEnum(PoolingMode.class) : null;
        this.normalizeResult = in.readBoolean();
        this.modelMaxLength = in.readOptionalInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.embeddingDimension.intValue());
        out.writeEnum((Enum)this.frameworkType);
        if (this.poolingMode != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.poolingMode);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.normalizeResult);
        out.writeOptionalInt(this.modelMaxLength);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelType != null) {
            builder.field("model_type", this.modelType);
        }
        if (this.embeddingDimension != null) {
            builder.field(EMBEDDING_DIMENSION_FIELD, this.embeddingDimension);
        }
        if (this.frameworkType != null) {
            builder.field(FRAMEWORK_TYPE_FIELD, (Object)this.frameworkType);
        }
        if (this.allConfig != null) {
            builder.field("all_config", this.allConfig);
        }
        if (this.modelMaxLength != null) {
            builder.field(MODEL_MAX_LENGTH_FIELD, this.modelMaxLength);
        }
        if (this.poolingMode != null) {
            builder.field(POOLING_MODE_FIELD, (Object)this.poolingMode);
        }
        if (this.normalizeResult) {
            builder.field(NORMALIZE_RESULT_FIELD, this.normalizeResult);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static TextEmbeddingModelConfigBuilder builder() {
        return new TextEmbeddingModelConfigBuilder();
    }

    @Generated
    public TextEmbeddingModelConfigBuilder toBuilder() {
        return new TextEmbeddingModelConfigBuilder().modelType(this.modelType).embeddingDimension(this.embeddingDimension).frameworkType(this.frameworkType).allConfig(this.allConfig).poolingMode(this.poolingMode).normalizeResult(this.normalizeResult).modelMaxLength(this.modelMaxLength);
    }

    @Generated
    public Integer getEmbeddingDimension() {
        return this.embeddingDimension;
    }

    @Generated
    public FrameworkType getFrameworkType() {
        return this.frameworkType;
    }

    @Generated
    public PoolingMode getPoolingMode() {
        return this.poolingMode;
    }

    @Generated
    public boolean isNormalizeResult() {
        return this.normalizeResult;
    }

    @Generated
    public Integer getModelMaxLength() {
        return this.modelMaxLength;
    }

    public static enum FrameworkType {
        HUGGINGFACE_TRANSFORMERS,
        SENTENCE_TRANSFORMERS,
        HUGGINGFACE_TRANSFORMERS_NEURON;


        public static FrameworkType from(String value) {
            try {
                return FrameworkType.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong framework type");
            }
        }
    }

    public static enum PoolingMode {
        MEAN("mean"),
        MEAN_SQRT_LEN("mean_sqrt_len"),
        MAX("max"),
        WEIGHTED_MEAN("weightedmean"),
        CLS("cls"),
        LAST_TOKEN("lasttoken");

        private String name;

        public String getName() {
            return this.name;
        }

        private PoolingMode(String name) {
            this.name = name;
        }

        public static PoolingMode from(String value) {
            try {
                return PoolingMode.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong pooling method");
            }
        }
    }

    @Generated
    public static class TextEmbeddingModelConfigBuilder {
        @Generated
        private String modelType;
        @Generated
        private Integer embeddingDimension;
        @Generated
        private FrameworkType frameworkType;
        @Generated
        private String allConfig;
        @Generated
        private PoolingMode poolingMode;
        @Generated
        private boolean normalizeResult;
        @Generated
        private Integer modelMaxLength;

        @Generated
        TextEmbeddingModelConfigBuilder() {
        }

        @Generated
        public TextEmbeddingModelConfigBuilder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder embeddingDimension(Integer embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder frameworkType(FrameworkType frameworkType) {
            this.frameworkType = frameworkType;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder allConfig(String allConfig) {
            this.allConfig = allConfig;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder poolingMode(PoolingMode poolingMode) {
            this.poolingMode = poolingMode;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder normalizeResult(boolean normalizeResult) {
            this.normalizeResult = normalizeResult;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder modelMaxLength(Integer modelMaxLength) {
            this.modelMaxLength = modelMaxLength;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfig build() {
            return new TextEmbeddingModelConfig(this.modelType, this.embeddingDimension, this.frameworkType, this.allConfig, this.poolingMode, this.normalizeResult, this.modelMaxLength);
        }

        @Generated
        public String toString() {
            return "TextEmbeddingModelConfig.TextEmbeddingModelConfigBuilder(modelType=" + this.modelType + ", embeddingDimension=" + this.embeddingDimension + ", frameworkType=" + this.frameworkType + ", allConfig=" + this.allConfig + ", poolingMode=" + this.poolingMode + ", normalizeResult=" + this.normalizeResult + ", modelMaxLength=" + this.modelMaxLength + ")";
        }
    }
}

