/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window.aggregation;

import java.util.Iterator;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.expression.window.WindowFunctionExpression;
import org.opensearch.sql.expression.window.frame.PeerRowsWindowFrame;
import org.opensearch.sql.expression.window.frame.WindowFrame;

public class AggregateWindowFunction
implements WindowFunctionExpression {
    private final Aggregator<AggregationState> aggregator;
    private AggregationState state;

    @Override
    public WindowFrame createWindowFrame(WindowDefinition definition) {
        return new PeerRowsWindowFrame(definition);
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        PeerRowsWindowFrame frame = (PeerRowsWindowFrame)valueEnv;
        if (frame.isNewPartition()) {
            this.state = this.aggregator.create();
        }
        Object peers = frame.next();
        Iterator iterator = peers.iterator();
        while (iterator.hasNext()) {
            ExprValue peer = (ExprValue)iterator.next();
            this.state = this.aggregator.iterate(peer.bindingTuples(), this.state);
        }
        return this.state.result();
    }

    @Override
    public ExprType type() {
        return this.aggregator.type();
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor, C context) {
        return this.aggregator.accept(visitor, context);
    }

    public String toString() {
        return this.aggregator.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateWindowFunction)) {
            return false;
        }
        AggregateWindowFunction other = (AggregateWindowFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Aggregator<AggregationState> this$aggregator = this.aggregator;
        Aggregator<AggregationState> other$aggregator = other.aggregator;
        if (this$aggregator == null ? other$aggregator != null : !((Object)this$aggregator).equals(other$aggregator)) {
            return false;
        }
        AggregationState this$state = this.state;
        AggregationState other$state = other.state;
        return !(this$state == null ? other$state != null : !this$state.equals(other$state));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AggregateWindowFunction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Aggregator<AggregationState> $aggregator = this.aggregator;
        result = result * 59 + ($aggregator == null ? 43 : ((Object)$aggregator).hashCode());
        AggregationState $state = this.state;
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    @Generated
    public AggregateWindowFunction(Aggregator<AggregationState> aggregator) {
        this.aggregator = aggregator;
    }
}

