/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor.pagination;

import java.util.List;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.Node;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.And;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Between;
import org.opensearch.sql.ast.expression.Case;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.ast.expression.Compare;
import org.opensearch.sql.ast.expression.EqualTo;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.HighlightFunction;
import org.opensearch.sql.ast.expression.In;
import org.opensearch.sql.ast.expression.Interval;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Not;
import org.opensearch.sql.ast.expression.Or;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.RelevanceFieldList;
import org.opensearch.sql.ast.expression.UnresolvedArgument;
import org.opensearch.sql.ast.expression.UnresolvedAttribute;
import org.opensearch.sql.ast.expression.When;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.expression.Xor;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Limit;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Values;
import org.opensearch.sql.expression.function.BuiltinFunctionName;

public class CanPaginateVisitor
extends AbstractNodeVisitor<Boolean, Object> {
    @Override
    public Boolean visitRelation(Relation node, Object context) {
        if (!node.getChild().isEmpty()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean canPaginate(Node node, Object context) {
        List<? extends Node> childList = node.getChild();
        if (childList != null) {
            return childList.stream().allMatch(n -> n.accept(this, context));
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitSort(Sort node, Object context) {
        return node.getSortList().stream().allMatch(f -> f.getField() instanceof QualifiedName && this.visitField((Field)f, context) != false) && this.canPaginate(node, context) != false;
    }

    @Override
    public Boolean visitFilter(Filter node, Object context) {
        return this.canPaginate(node, context) != false && node.getCondition().accept(this, context) != false;
    }

    @Override
    public Boolean visitAggregation(Aggregation node, Object context) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitValues(Values node, Object context) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitLimit(Limit node, Object context) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitLiteral(Literal node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitField(Field node, Object context) {
        return this.canPaginate(node, context) != false && node.getFieldArgs().stream().allMatch(n -> n.accept(this, context));
    }

    @Override
    public Boolean visitAlias(Alias node, Object context) {
        return this.canPaginate(node, context) != false && node.getDelegated().accept(this, context) != false;
    }

    @Override
    public Boolean visitAllFields(AllFields node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitQualifiedName(QualifiedName node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitEqualTo(EqualTo node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitRelevanceFieldList(RelevanceFieldList node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitInterval(Interval node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitCompare(Compare node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitNot(Not node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitOr(Or node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitAnd(And node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitArgument(Argument node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitXor(Xor node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitFunction(Function node, Object context) {
        if (node.getFuncName().equalsIgnoreCase(BuiltinFunctionName.NESTED.getName().getFunctionName())) {
            return Boolean.FALSE;
        }
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitIn(In node, Object context) {
        return this.canPaginate(node, context) != false && node.getValueList().stream().allMatch(n -> n.accept(this, context));
    }

    @Override
    public Boolean visitBetween(Between node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitCase(Case node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitWhen(When node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitCast(Cast node, Object context) {
        return this.canPaginate(node, context) != false && node.getConvertedType().accept(this, context) != false;
    }

    @Override
    public Boolean visitHighlightFunction(HighlightFunction node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitUnresolvedArgument(UnresolvedArgument node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitUnresolvedAttribute(UnresolvedAttribute node, Object context) {
        return this.canPaginate(node, context);
    }

    @Override
    public Boolean visitChildren(Node node, Object context) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitWindowFunction(WindowFunction node, Object context) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitProject(Project node, Object context) {
        if (!node.getProjectList().stream().allMatch(n -> n.accept(this, context))) {
            return Boolean.FALSE;
        }
        List<UnresolvedPlan> children = node.getChild();
        if (children.size() != 1) {
            return Boolean.FALSE;
        }
        return children.get(0).accept(this, context);
    }
}

