/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.io.Closeable;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.repositories.s3.AmazonS3Reference;
import org.opensearch.repositories.s3.AmazonS3WithCredentials;
import org.opensearch.repositories.s3.ProxySettings;
import org.opensearch.repositories.s3.S3ClientSettings;
import org.opensearch.repositories.s3.S3Repository;
import org.opensearch.repositories.s3.SocketAccess;
import org.opensearch.repositories.s3.utils.AwsRequestSigner;
import org.opensearch.repositories.s3.utils.Protocol;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SystemPropertyTlsKeyManagersProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.apache.internal.conn.SdkTlsSocketFactory;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsWebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

class S3Service
implements Closeable {
    private static final Logger logger = LogManager.getLogger(S3Service.class);
    private static final String STS_ENDPOINT_OVERRIDE_SYSTEM_PROPERTY = "aws.stsEndpointOverride";
    private static final String DEFAULT_S3_ENDPOINT = "s3.amazonaws.com";
    private volatile Map<S3ClientSettings, AmazonS3Reference> clientsCache = new ConcurrentHashMap<S3ClientSettings, AmazonS3Reference>();
    private volatile Map<String, S3ClientSettings> staticClientSettings;
    private volatile Map<Settings, S3ClientSettings> derivedClientSettings = new ConcurrentHashMap<Settings, S3ClientSettings>();

    S3Service(Path configPath) {
        this.staticClientSettings = MapBuilder.newMapBuilder().put((Object)"default", (Object)S3ClientSettings.getClientSettings(Settings.EMPTY, "default", configPath)).immutableMap();
    }

    public synchronized void refreshAndClearCache(Map<String, S3ClientSettings> clientsSettings) {
        this.releaseCachedClients();
        this.staticClientSettings = MapBuilder.newMapBuilder(clientsSettings).immutableMap();
        this.derivedClientSettings = Collections.emptyMap();
        assert (this.staticClientSettings.containsKey("default")) : "always at least have 'default'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonS3Reference client(RepositoryMetadata repositoryMetadata) {
        S3ClientSettings clientSettings = this.settings(repositoryMetadata);
        AmazonS3Reference clientReference = this.clientsCache.get(clientSettings);
        if (clientReference != null && clientReference.tryIncRef()) {
            return clientReference;
        }
        S3Service s3Service = this;
        synchronized (s3Service) {
            AmazonS3Reference existing = this.clientsCache.get(clientSettings);
            if (existing != null && existing.tryIncRef()) {
                return existing;
            }
            AmazonS3Reference clientReference2 = new AmazonS3Reference(this.buildClient(clientSettings));
            clientReference2.incRef();
            this.clientsCache = MapBuilder.newMapBuilder(this.clientsCache).put((Object)clientSettings, (Object)clientReference2).immutableMap();
            return clientReference2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    S3ClientSettings settings(RepositoryMetadata repositoryMetadata) {
        Settings settings = repositoryMetadata.settings();
        S3ClientSettings existing = this.derivedClientSettings.get(settings);
        if (existing != null) {
            return existing;
        }
        String clientName = (String)S3Repository.CLIENT_NAME.get(settings);
        S3ClientSettings staticSettings = this.staticClientSettings.get(clientName);
        if (staticSettings != null) {
            S3Service s3Service = this;
            synchronized (s3Service) {
                S3ClientSettings existing2 = this.derivedClientSettings.get(settings);
                if (existing2 != null) {
                    return existing2;
                }
                S3ClientSettings newSettings = staticSettings.refine(settings);
                this.derivedClientSettings = MapBuilder.newMapBuilder(this.derivedClientSettings).put((Object)settings, (Object)newSettings).immutableMap();
                return newSettings;
            }
        }
        throw new IllegalArgumentException("Unknown s3 client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.staticClientSettings.keySet(), (String)","));
    }

    AmazonS3WithCredentials buildClient(S3ClientSettings clientSettings) {
        S3Service.setDefaultAwsProfilePath();
        S3ClientBuilder builder = S3Client.builder();
        AwsCredentialsProvider credentials = S3Service.buildCredentials(logger, clientSettings);
        builder.credentialsProvider(credentials);
        builder.httpClientBuilder((SdkHttpClient.Builder)S3Service.buildHttpClient(clientSettings));
        builder.overrideConfiguration(S3Service.buildOverrideConfiguration(clientSettings));
        Object endpoint = Strings.hasLength((String)clientSettings.endpoint) ? clientSettings.endpoint : DEFAULT_S3_ENDPOINT;
        if (!(((String)endpoint).startsWith("http://") || ((String)endpoint).startsWith("https://"))) {
            endpoint = clientSettings.protocol.toString() + "://" + (String)endpoint;
        }
        logger.debug("using endpoint [{}] and region [{}]", endpoint, (Object)clientSettings.region);
        builder.endpointOverride(URI.create((String)endpoint));
        if (Strings.hasText((String)clientSettings.region)) {
            builder.region(Region.of((String)clientSettings.region));
        }
        if (clientSettings.pathStyleAccess) {
            builder.forcePathStyle(Boolean.valueOf(true));
        }
        if (clientSettings.disableChunkedEncoding) {
            builder.serviceConfiguration(s -> s.chunkedEncodingEnabled(Boolean.valueOf(false)));
        }
        S3Client client = SocketAccess.doPrivileged(() -> ((S3ClientBuilder)builder).build());
        return AmazonS3WithCredentials.create(client, credentials);
    }

    @SuppressForbidden(reason="Need to provide this override to v2 SDK so that path does not default to home path")
    static void setDefaultAwsProfilePath() {
        if (ProfileFileSystemSetting.AWS_SHARED_CREDENTIALS_FILE.getStringValue().isEmpty()) {
            SocketAccess.doPrivileged(() -> System.setProperty(ProfileFileSystemSetting.AWS_SHARED_CREDENTIALS_FILE.property(), System.getProperty("opensearch.path.conf")));
        }
        if (ProfileFileSystemSetting.AWS_CONFIG_FILE.getStringValue().isEmpty()) {
            SocketAccess.doPrivileged(() -> System.setProperty(ProfileFileSystemSetting.AWS_CONFIG_FILE.property(), System.getProperty("opensearch.path.conf")));
        }
    }

    static ApacheHttpClient.Builder buildHttpClient(final S3ClientSettings clientSettings) {
        ApacheHttpClient.Builder clientBuilder = ApacheHttpClient.builder();
        if (!clientSettings.proxySettings.equals(ProxySettings.NO_PROXY_SETTINGS)) {
            if (clientSettings.proxySettings.getType() == ProxySettings.ProxyType.SOCKS) {
                SocketAccess.doPrivilegedVoid(() -> {
                    if (clientSettings.proxySettings.isAuthenticated()) {
                        Authenticator.setDefault(new Authenticator(){

                            @Override
                            protected PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(clientSettings.proxySettings.getUsername(), clientSettings.proxySettings.getPassword().toCharArray());
                            }
                        });
                    }
                    clientBuilder.socketFactory((ConnectionSocketFactory)S3Service.createSocksSslConnectionSocketFactory(clientSettings.proxySettings.getAddress()));
                });
            } else {
                clientBuilder.proxyConfiguration(S3Service.buildHttpProxyConfiguration(clientSettings));
            }
        }
        clientBuilder.socketTimeout(Duration.ofMillis(clientSettings.readTimeoutMillis));
        return clientBuilder;
    }

    static ProxyConfiguration buildHttpProxyConfiguration(S3ClientSettings clientSettings) {
        ProxyConfiguration.Builder proxyConfiguration = ProxyConfiguration.builder();
        if (clientSettings.proxySettings.getType() == ProxySettings.ProxyType.SOCKS) {
            return (ProxyConfiguration)proxyConfiguration.build();
        }
        Protocol proxyProtocol = clientSettings.proxySettings.getType() == ProxySettings.ProxyType.DIRECT ? Protocol.HTTP : clientSettings.proxySettings.getType().toProtocol();
        try {
            proxyConfiguration = proxyConfiguration.endpoint(new URI(proxyProtocol.toString(), null, clientSettings.proxySettings.getHost(), clientSettings.proxySettings.getPort(), null, null, null));
        }
        catch (URISyntaxException e) {
            throw SdkException.create((String)"Invalid proxy URL", (Throwable)e);
        }
        proxyConfiguration = proxyConfiguration.username(clientSettings.proxySettings.getUsername());
        proxyConfiguration = proxyConfiguration.password(clientSettings.proxySettings.getPassword());
        return (ProxyConfiguration)proxyConfiguration.build();
    }

    static ClientOverrideConfiguration buildOverrideConfiguration(S3ClientSettings clientSettings) {
        ClientOverrideConfiguration.Builder clientOverrideConfiguration = ClientOverrideConfiguration.builder();
        if (Strings.hasLength((String)clientSettings.signerOverride)) {
            clientOverrideConfiguration = clientOverrideConfiguration.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)AwsRequestSigner.fromSignerName(clientSettings.signerOverride).getSigner());
        }
        RetryPolicy.Builder retryPolicy = SocketAccess.doPrivileged(() -> RetryPolicy.builder().numRetries(Integer.valueOf(clientSettings.maxRetries)).retryCapacityCondition(null));
        if (!clientSettings.throttleRetries) {
            retryPolicy.throttlingBackoffStrategy(BackoffStrategy.none());
        }
        return (ClientOverrideConfiguration)clientOverrideConfiguration.retryPolicy(retryPolicy.build()).build();
    }

    private static SSLConnectionSocketFactory createSocksSslConnectionSocketFactory(final InetSocketAddress address) {
        try {
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(SystemPropertyTlsKeyManagersProvider.create().keyManagers(), null, new SecureRandom());
            return new SdkTlsSocketFactory(sslCtx, (HostnameVerifier)new DefaultHostnameVerifier()){

                public Socket createSocket(HttpContext ctx) throws IOException {
                    return new Socket(new Proxy(Proxy.Type.SOCKS, address));
                }
            };
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw SdkException.create((String)"Exception during SSL context creation for SOCKS proxy", (Throwable)e);
        }
    }

    static AwsCredentialsProvider buildCredentials(Logger logger, S3ClientSettings clientSettings) {
        AwsCredentials basicCredentials = clientSettings.credentials;
        S3ClientSettings.IrsaCredentials irsaCredentials = S3Service.buildFromEnviroment(clientSettings.irsaCredentials);
        if (irsaCredentials != null) {
            logger.debug("Using IRSA credentials");
            StsClient stsClient = SocketAccess.doPrivileged(() -> {
                String stsEndpoint;
                StsClientBuilder builder = StsClient.builder();
                if (Strings.hasText((String)clientSettings.region)) {
                    builder.region(Region.of((String)clientSettings.region));
                }
                if ((stsEndpoint = System.getProperty(STS_ENDPOINT_OVERRIDE_SYSTEM_PROPERTY)) != null) {
                    builder = (StsClientBuilder)builder.endpointOverride(URI.create(stsEndpoint));
                }
                builder = basicCredentials != null ? (StsClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)basicCredentials)) : (StsClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create());
                return (StsClient)builder.build();
            });
            if (irsaCredentials.getIdentityTokenFile() == null) {
                StsAssumeRoleCredentialsProvider.Builder stsCredentialsProviderBuilder = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(irsaCredentials.getRoleArn()).roleSessionName(irsaCredentials.getRoleSessionName()).build());
                StsAssumeRoleCredentialsProvider stsCredentialsProvider = SocketAccess.doPrivileged(() -> ((StsAssumeRoleCredentialsProvider.Builder)stsCredentialsProviderBuilder).build());
                return new PrivilegedSTSAssumeRoleSessionCredentialsProvider<StsAssumeRoleCredentialsProvider>(stsClient, stsCredentialsProvider);
            }
            StsWebIdentityTokenFileCredentialsProvider.Builder stsCredentialsProviderBuilder = StsWebIdentityTokenFileCredentialsProvider.builder().stsClient(stsClient).roleArn(irsaCredentials.getRoleArn()).roleSessionName(irsaCredentials.getRoleSessionName()).webIdentityTokenFile(Path.of(irsaCredentials.getIdentityTokenFile(), new String[0]));
            StsWebIdentityTokenFileCredentialsProvider stsCredentialsProvider = SocketAccess.doPrivileged(() -> ((StsWebIdentityTokenFileCredentialsProvider.Builder)stsCredentialsProviderBuilder).build());
            return new PrivilegedSTSAssumeRoleSessionCredentialsProvider<StsWebIdentityTokenFileCredentialsProvider>(stsClient, stsCredentialsProvider);
        }
        if (basicCredentials != null) {
            logger.debug("Using basic key/secret credentials");
            return StaticCredentialsProvider.create((AwsCredentials)basicCredentials);
        }
        logger.debug("Using instance profile credentials");
        return new PrivilegedInstanceProfileCredentialsProvider();
    }

    private static S3ClientSettings.IrsaCredentials buildFromEnviroment(S3ClientSettings.IrsaCredentials defaults) {
        String roleSessionName;
        String roleArn;
        if (defaults == null) {
            return null;
        }
        String webIdentityTokenFile = defaults.getIdentityTokenFile();
        if (webIdentityTokenFile == null) {
            webIdentityTokenFile = System.getenv(SdkSystemSetting.AWS_WEB_IDENTITY_TOKEN_FILE.environmentVariable());
        }
        if ((roleArn = defaults.getRoleArn()) == null) {
            roleArn = System.getenv(SdkSystemSetting.AWS_ROLE_ARN.environmentVariable());
        }
        if ((roleSessionName = defaults.getRoleSessionName()) == null) {
            roleSessionName = System.getenv(SdkSystemSetting.AWS_ROLE_SESSION_NAME.environmentVariable());
        }
        return new S3ClientSettings.IrsaCredentials(webIdentityTokenFile, roleArn, roleSessionName);
    }

    private synchronized void releaseCachedClients() {
        for (AmazonS3Reference clientReference : this.clientsCache.values()) {
            clientReference.decRef();
        }
        this.clientsCache = Collections.emptyMap();
        this.derivedClientSettings = Collections.emptyMap();
    }

    @Override
    public void close() {
        this.releaseCachedClients();
    }

    static class PrivilegedSTSAssumeRoleSessionCredentialsProvider<P extends AwsCredentialsProvider & AutoCloseable>
    implements AwsCredentialsProvider,
    Closeable {
        private final P credentials;
        private final StsClient stsClient;

        private PrivilegedSTSAssumeRoleSessionCredentialsProvider(@Nullable StsClient stsClient, P credentials) {
            this.stsClient = stsClient;
            this.credentials = credentials;
        }

        @Override
        public void close() throws IOException {
            SocketAccess.doPrivilegedIOException(() -> {
                ((AutoCloseable)this.credentials).close();
                if (this.stsClient != null) {
                    this.stsClient.close();
                }
                return null;
            });
        }

        public AwsCredentials resolveCredentials() {
            return SocketAccess.doPrivileged(() -> this.credentials.resolveCredentials());
        }
    }

    static class PrivilegedInstanceProfileCredentialsProvider
    implements AwsCredentialsProvider {
        private final AwsCredentialsProvider credentials = this.initializeProvider();

        private PrivilegedInstanceProfileCredentialsProvider() {
        }

        private AwsCredentialsProvider initializeProvider() {
            if (SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_RELATIVE_URI.getStringValue().isPresent() || SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_FULL_URI.getStringValue().isPresent()) {
                return ((ContainerCredentialsProvider.Builder)ContainerCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
            }
            return ((InstanceProfileCredentialsProvider.Builder)InstanceProfileCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
        }

        public AwsCredentials resolveCredentials() {
            return SocketAccess.doPrivileged(() -> ((AwsCredentialsProvider)this.credentials).resolveCredentials());
        }
    }
}

