'use strict';

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MetricsAggregationBase = require('./metrics-aggregation-base');

/**
 * A single-value metrics aggregation that computes the average of numeric
 * values that are extracted from the aggregated documents. These values can be
 * extracted either from specific numeric fields in the documents, or be
 * generated by a provided script.
 *
 * [Elasticsearch reference](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-avg-aggregation.html)
 *
 * Aggregation that computes the average of numeric values that are extracted
 * from the aggregated documents.
 *
 * @example
 * // Compute the average grade over all documents
 * const agg = esb.avgAggregation('avg_grade', 'grade');
 *
 * @example
 * // Compute the average grade based on a script
 * const agg = esb.avgAggregation('avg_grade').script(
 *     esb.script('inline', "doc['grade'].value").lang('painless')
 * );
 *
 * @example
 * // Value script, apply grade correction
 * const agg = esb.avgAggregation('avg_grade', 'grade').script(
 *     esb.script('inline', '_value * params.correction')
 *         .lang('painless')
 *         .params({ correction: 1.2 })
 * );
 *
 * @example
 * // Missing value
 * const agg = esb.avgAggregation('avg_grade', 'grade').missing(10);
 *
 * @param {string} name The name which will be used to refer to this aggregation.
 * @param {string=} field The field to aggregate on
 *
 * @extends MetricsAggregationBase
 */

var AvgAggregation = function (_MetricsAggregationBa) {
    (0, _inherits3.default)(AvgAggregation, _MetricsAggregationBa);

    // eslint-disable-next-line require-jsdoc
    function AvgAggregation(name, field) {
        (0, _classCallCheck3.default)(this, AvgAggregation);
        return (0, _possibleConstructorReturn3.default)(this, (AvgAggregation.__proto__ || Object.getPrototypeOf(AvgAggregation)).call(this, name, 'avg', field));
    }

    return AvgAggregation;
}(MetricsAggregationBase);

module.exports = AvgAggregation;