"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _sample_savedObjects = require("../../common/helpers/events_explorer/sample_savedObjects");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// eslint-disable-next-line import/no-default-export
class SavedObjectFacet {
  constructor(client) {
    this.client = client;

    _defineProperty(this, "fetch", async (request, params, format) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics fetch error: ', err);
        res.data = err;
      }

      return res;
    });

    _defineProperty(this, "create", async (request, format, objectType) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          body: {
            [objectType]: { ...request.body.object
            }
          }
        };
        const savedRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedRes;
      } catch (err) {
        console.error('Event analytics create error: ', err);
        res.data = err;
      }

      return res;
    });

    _defineProperty(this, "createTimestamp", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          body: {
            objectId: request.body.index,
            timestamp: { ...request.body
            }
          }
        };
        const savedRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedRes;
      } catch (err) {
        console.error('Event analytics create timestamp error: ', err);
        res.data = err;
      }

      return res;
    });

    _defineProperty(this, "updateTimestamp", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          objectId: request.body.objectId,
          body: { ...request.body
          }
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics update error: ', err);
        res.data = err.message;
      }

      return res;
    });

    _defineProperty(this, "update", async (request, format, objectType) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          objectId: request.body.object_id,
          body: {
            [objectType]: { ...request.body.object
            }
          }
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics update error: ', err);
        res.data = err.message;
      }

      return res;
    });

    _defineProperty(this, "delete", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          objectIdList: request.params.objectIdList
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics delete error: ', err);
        res.data = err.message;
      }

      return res;
    });

    _defineProperty(this, "createSamples", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const savedVizIds = [];
        const savedQueryIds = [];

        if (['panels', 'event_analytics'].includes(request.params.sampleRequestor)) {
          for (let i = 0; i < _sample_savedObjects.sampleVisualizations.length; i++) {
            const params = {
              body: {
                savedVisualization: { ..._sample_savedObjects.sampleVisualizations[i]
                }
              }
            };
            const savedVizRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
            savedVizIds.push(savedVizRes.objectId);
          }

          for (let i = 0; i < _sample_savedObjects.sampleQueries.length; i++) {
            const params = {
              body: {
                savedQuery: { ..._sample_savedObjects.sampleQueries[i]
                }
              }
            };
            const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
            savedQueryIds.push(savedQueryRes.objectId);
          }
        }

        res.success = true;
        res.data = {
          savedVizIds,
          savedQueryIds
        };
      } catch (err) {
        console.error('Event analytics create error: ', err);
        res.data = err;
      }

      return res;
    });

    _defineProperty(this, "getSavedObject", async request => {
      const params = {};

      for (const [param, value] of request.url.searchParams.entries()) {
        params[param] = value;
      }

      return this.fetch(request, { ...params
      }, 'observability.getObject');
    });

    _defineProperty(this, "createSavedQuery", async request => {
      return this.create(request, 'observability.createObject', 'savedQuery');
    });

    _defineProperty(this, "createSavedVisualization", request => {
      return this.create(request, 'observability.createObject', 'savedVisualization');
    });

    _defineProperty(this, "createSavedTimestamp", request => {
      return this.createTimestamp(request, 'observability.createObject');
    });

    _defineProperty(this, "updateSavedTimestamp", request => {
      return this.updateTimestamp(request, 'observability.updateObjectById');
    });

    _defineProperty(this, "updateSavedQuery", request => {
      return this.update(request, 'observability.updateObjectById', 'savedQuery');
    });

    _defineProperty(this, "updateSavedVisualization", request => {
      return this.update(request, 'observability.updateObjectById', 'savedVisualization');
    });

    _defineProperty(this, "deleteSavedObject", async request => {
      return this.delete(request, 'observability.deleteObjectByIdList');
    });

    _defineProperty(this, "createSampleSavedObjects", async request => {
      return this.createSamples(request, 'observability.createObject');
    });

    this.client = client;
  }

}

exports.default = SavedObjectFacet;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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