function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as fs from 'fs';
import * as path from 'path';
import { promisify } from 'util';
import { unique } from './core/helper';
var TRANSLATION_FILE_EXTENSION = '.json';
/**
 * Internal property for storing registered translations paths.
 * Key is locale, value is array of registered paths
 */

var translationsRegistry = {};
/**
 * Internal property for caching loaded translations files.
 * Key is path to translation file, value is object with translation messages
 */

var loadedFiles = {};
/**
 * Returns locale by the given translation file name
 * @param fullFileName
 * @returns locale
 * @example
 * getLocaleFromFileName('./path/to/translation/ru.json') // => 'ru'
 */

function getLocaleFromFileName(fullFileName) {
  if (!fullFileName) {
    throw new Error('Filename is empty');
  }

  var fileExt = path.extname(fullFileName);

  if (fileExt !== TRANSLATION_FILE_EXTENSION) {
    throw new Error("Translations must have 'json' extension. File being registered is ".concat(fullFileName));
  }

  return path.basename(fullFileName, TRANSLATION_FILE_EXTENSION);
}
/**
 * Loads file and parses it as JSON
 * @param pathToFile
 * @returns
 */


function loadFile(_x) {
  return _loadFile.apply(this, arguments);
}
/**
 * Loads translations files and adds them into "loadedFiles" cache
 * @param files
 * @returns
 */


function _loadFile() {
  _loadFile = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(pathToFile) {
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.t0 = JSON;
            _context.next = 3;
            return promisify(fs.readFile)(pathToFile, 'utf8');

          case 3:
            _context.t1 = _context.sent;
            return _context.abrupt("return", _context.t0.parse.call(_context.t0, _context.t1));

          case 5:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _loadFile.apply(this, arguments);
}

function loadAndCacheFiles(_x2) {
  return _loadAndCacheFiles.apply(this, arguments);
}
/**
 * Registers translation file with i18n loader
 * @param translationFilePath - Absolute path to the translation file to register.
 */


function _loadAndCacheFiles() {
  _loadAndCacheFiles = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(files) {
    var translations;
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return Promise.all(files.map(loadFile));

          case 2:
            translations = _context2.sent;
            files.forEach(function (file, index) {
              loadedFiles[file] = translations[index];
            });

          case 4:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _loadAndCacheFiles.apply(this, arguments);
}

export function registerTranslationFile(translationFilePath) {
  if (!path.isAbsolute(translationFilePath)) {
    throw new TypeError('Paths to translation files must be absolute. ' + "Got relative path: \"".concat(translationFilePath, "\""));
  }

  var locale = getLocaleFromFileName(translationFilePath);
  translationsRegistry[locale] = unique([].concat(_toConsumableArray(translationsRegistry[locale] || []), [translationFilePath]));
}
/**
 * Registers array of translation files with i18n loader
 * @param arrayOfPaths - Array of absolute paths to the translation files to register.
 */

export function registerTranslationFiles() {
  var arrayOfPaths = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  arrayOfPaths.forEach(registerTranslationFile);
}
/**
 * Returns an array of locales that have been registered with i18n loader
 * @returns registeredTranslations
 */

export function getRegisteredLocales() {
  return Object.keys(translationsRegistry);
}
/**
 * Returns translation messages by specified locale
 * @param locale
 * @returns translation messages
 */

export function getTranslationsByLocale(_x3) {
  return _getTranslationsByLocale.apply(this, arguments);
}
/**
 * Returns all translations for registered locales
 * @returns A Promise object
 * where keys are the locale and values are objects of translation messages
 */

function _getTranslationsByLocale() {
  _getTranslationsByLocale = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(locale) {
    var files, notLoadedFiles;
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            files = translationsRegistry[locale] || [];
            notLoadedFiles = files.filter(function (file) {
              return !loadedFiles[file];
            });

            if (!notLoadedFiles.length) {
              _context3.next = 5;
              break;
            }

            _context3.next = 5;
            return loadAndCacheFiles(notLoadedFiles);

          case 5:
            if (files.length) {
              _context3.next = 7;
              break;
            }

            return _context3.abrupt("return", {
              messages: {}
            });

          case 7:
            return _context3.abrupt("return", files.reduce(function (translation, file) {
              return {
                locale: loadedFiles[file].locale || translation.locale,
                formats: loadedFiles[file].formats || translation.formats,
                messages: _objectSpread(_objectSpread({}, loadedFiles[file].messages), translation.messages)
              };
            }, {
              locale: locale,
              messages: {}
            }));

          case 8:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _getTranslationsByLocale.apply(this, arguments);
}

export function getAllTranslations() {
  return _getAllTranslations.apply(this, arguments);
}
/**
 * Registers passed translations files, loads them and returns promise with
 * all translation messages
 * @param paths - Array of absolute paths to the translation files
 * @returns A Promise object where
 * keys are the locale and values are objects of translation messages
 */

function _getAllTranslations() {
  _getAllTranslations = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
    var locales, translations;
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            locales = getRegisteredLocales();
            _context4.next = 3;
            return Promise.all(locales.map(getTranslationsByLocale));

          case 3:
            translations = _context4.sent;
            return _context4.abrupt("return", locales.reduce(function (acc, locale, index) {
              return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, locale, translations[index]));
            }, {}));

          case 5:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _getAllTranslations.apply(this, arguments);
}

export function getAllTranslationsFromPaths(_x4) {
  return _getAllTranslationsFromPaths.apply(this, arguments);
}

function _getAllTranslationsFromPaths() {
  _getAllTranslationsFromPaths = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(paths) {
    return regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            registerTranslationFiles(paths);
            _context5.next = 3;
            return getAllTranslations();

          case 3:
            return _context5.abrupt("return", _context5.sent);

          case 4:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  }));
  return _getAllTranslationsFromPaths.apply(this, arguments);
}