import glob

override = True
test_text = """
    def test_timeago_%s(self):
        locale = '%s'
    
        date = datetime.datetime.now()
        now = date + datetime.timedelta(seconds=2)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=10)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=60)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=60 * 3.4)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=3600)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=3600 * 2)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=86400)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=86400 * 4.5)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=86400 * 7)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=2592000)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=86400 * 31)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=2592000 * 3.5)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=31536000)
        self.assertEqual(timeago.format(date, now, locale), "%s")
    
        now = date + datetime.timedelta(seconds=31536000 * 2.1)
        self.assertEqual(timeago.format(date, now, locale), "%s")"""

deltas = [10, 3, 2, 4, 4, 3, 2]

test_functions = []

for filename in glob.glob('./*py'):
    with open(filename) as f:
        content = f.read()
        # We need to use a bit of reflexion to load the module dynamically
        if not 'generated by @lolobosse script' in content:
            continue
        locale_name = filename[2:-3]
        print('Generating tests for %s' % locale_name)
        if "import_locale" or "create_tests" in filename:
            continue
        try:
            values = __import__(locale_name).LOCALE
        except:
            print('No locale found for %s' % locale_name)
            continue
        args = [locale_name, locale_name]
        for index, line in enumerate(values):
            if index % 2 == 1:
                # With format
                args.append(line[0] % str(deltas[index/2]))
            else:
                args.append(line[0])
        result = test_text % tuple(args)
        test_functions.append(result)

with open('../../../test/testcase.py', 'r') as input:
    content = input.readlines()
    line_number = 0
    for index, line in enumerate(content):
        if '__name__' in line:
            line_number = index
    content.insert(line_number - 2, ("\n"*2).join(test_functions))
    text = "".join(content)
    input.close()

if not override:
    with open('../../../test/testcase2.py', 'w+') as result:
        result.write(text)
        result.close()
else:
    open('../../../test/testcase.py', 'w').close()
    with open('../../../test/testcase.py', 'w') as original:
        original.write(text)
        original.close()