/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import mediathek.config.Config;
import mediathek.tool.FileUtils;
import mediathek.tool.http.ByteCounter;
import mediathek.tool.http.MVHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeStatistics {
    public static final LocalDateTime startZeit = LocalDateTime.now();

    public static void printRuntimeStatistics() {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        LocalDateTime endZeit = LocalDateTime.now();
        LocalTime runTime = LocalTime.MIN.plusSeconds(Duration.between(startZeit, endZeit).toSeconds());
        Logger logger = LogManager.getLogger();
        logger.info("################################################################################");
        logger.info("   --> Start: {}", (Object)formatter.format(startZeit));
        logger.info("   --> Ende:  {}", (Object)formatter.format(endZeit));
        logger.info("   --> Laufzeit: {}h {}m {}s", (Object)runTime.getHour(), (Object)runTime.getMinute(), (Object)runTime.getSecond());
    }

    public static void printDataUsageStatistics() {
        if (Config.isEnhancedLoggingEnabled()) {
            ByteCounter byteCounter = MVHttpClient.getInstance().getByteCounter();
            Logger logger = LogManager.getLogger();
            logger.info("total data sent: {}", (Object)FileUtils.humanReadableByteCountBinary(byteCounter.totalBytesWritten()));
            logger.info("total data received: {}", (Object)FileUtils.humanReadableByteCountBinary(byteCounter.totalBytesRead()));
        }
    }
}

