/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public abstract class AbstractModifyFileAction
extends SystemInstallOrUninstallAction {
    protected abstract boolean modifyFile(File var1, Context var2) throws IOException, UserCanceledException;

    protected boolean executeForSingleFile(Context context, File file) throws UserCanceledException {
        File usedFile = this.resolveRelativeFile(file, context);
        try {
            if (this.fileMustExist() && !usedFile.exists()) {
                Logger.getInstance().error(this, "The file " + usedFile.getAbsolutePath() + " does not exist.");
                return false;
            }
            if (context instanceof InstallerContext && !this.isSuppressRollback()) {
                if (this.fileWillBeCreated() && !usedFile.exists()) {
                    BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(usedFile, true);
                    backupAction.install((InstallerContext)context);
                    this.addRollbackAction(backupAction);
                } else if (usedFile.isFile()) {
                    BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(usedFile, false);
                    backupAction.install((InstallerContext)context);
                    this.addRollbackAction(backupAction);
                }
            }
            return this.modifyFile(usedFile, context);
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
    }

    protected boolean executeForMultipleFiles(Context context, File[] files) throws UserCanceledException {
        if (files == null) {
            return true;
        }
        boolean success = true;
        for (File file : files) {
            success &= this.executeForSingleFile(context, file);
        }
        return success;
    }

    protected boolean fileMustExist() {
        return false;
    }

    protected boolean fileWillBeCreated() {
        return false;
    }

    protected Object maybeFilterLogReplacement(String propertyName, String replacementPropertyName, Object propertyValue, boolean logReplacement) {
        if (Objects.equals(propertyName, replacementPropertyName) && !logReplacement) {
            return "[logging of replacement text is disabled]";
        }
        return propertyValue;
    }
}

