/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.builder.CharacterWithDiagnostic;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirLegacyRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.builder.FirLegacyRawContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousObjectBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyAccessorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirReceiverParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirLazyExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBinaryLogicExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckedSafeCallSubjectBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComparisonExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirElvisExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSafeCallExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWrappedDelegateExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.builder.FirDelegateFieldReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirImplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirTypeProjectionWithVarianceBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty2TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty2TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitTypeRefImplWithoutSource;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0088\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0005\u001a\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a.\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%\u001a\u0018\u0010&\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020)\u001a\u0010\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-\u001a\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200H\u0000\u001a\f\u00101\u001a\u00020\u0001*\u0004\u0018\u000102\u001a\n\u00103\u001a\u000204*\u00020 \u001a\u0016\u00105\u001a\u00020\u0001*\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0002\u001a\n\u00106\u001a\u000204*\u000207\u001a0\u00108\u001a\u000209*\u00020\u000f2\b\u0010:\u001a\u0004\u0018\u00010 2\b\u0010;\u001a\u0004\u0018\u00010 2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020#H\u0002\u001a\u001a\u0010>\u001a\u00020?*\u00020\u001e2\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020 \u001a\u001e\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u0011*\b\u0012\u0004\u0012\u00020B0\u00112\u0006\u0010C\u001a\u000202\u001aR\u0010D\u001a\u00020E\"\u0004\b\u0000\u0010\u0016*\u00020F2\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020J2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010K\u001a\u00020\u00012\n\b\u0002\u0010L\u001a\u0004\u0018\u00010M\u001a.\u0010N\u001a\u00020O*\u00020\u000f2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020Q2\b\u0010;\u001a\u0004\u0018\u00010 2\b\u0010:\u001a\u0004\u0018\u00010 \u001a.\u0010R\u001a\u000209*\u00020\u000f2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010S\u001a\u00020\u00012\b\u0010;\u001a\u0004\u0018\u00010 2\b\u0010:\u001a\u0004\u0018\u00010 \u001a$\u0010T\u001a\u00020U*\u00020\u000f2\u0006\u0010V\u001a\u00020\u000f2\u0006\u0010W\u001a\u00020\u00012\b\u0010;\u001a\u0004\u0018\u00010 \u001a\u001c\u0010X\u001a\u00020Y*\u00020\u000f2\u0006\u0010V\u001a\u00020\u000f2\b\u0010;\u001a\u0004\u0018\u00010 \u001a\u001e\u0010Z\u001a\u00020E\"\u0004\b\u0000\u0010\u0016*\u00020[2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018\u001a\u001b\u0010\\\u001a\u00020\u0001*\u00020]\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\n\u0010^\u001a\u00020\u0001*\u00020-\u001a\n\u0010_\u001a\u00020\u001a*\u00020\u001c\u001a\n\u0010`\u001a\u00020\u000f*\u00020\u000f\u001a\f\u0010a\u001a\u0004\u0018\u00010#*\u00020Q\u001a\n\u0010b\u001a\u00020c*\u00020Q\u001a\f\u0010d\u001a\u0004\u0018\u00010c*\u00020Q\u001a\n\u0010e\u001a\u00020f*\u000209\u001a\f\u0010g\u001a\u0004\u0018\u00010#*\u00020Q\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001f\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f2\u0001\u0004\n\u000209\u00a8\u0006h"}, d2={"isUnderscore", "", "", "(Ljava/lang/CharSequence;)Z", "ownerRegularClassTypeParametersCount", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "getOwnerRegularClassTypeParametersCount", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Ljava/lang/Integer;", "ownerRegularOrAnonymousObjectSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getOwnerRegularOrAnonymousObjectSymbol", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "buildBalancedOrExpressionTree", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "conditions", "", "lower", "upper", "currentDispatchReceiverType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "T", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "escapedStringToCharacter", "Lorg/jetbrains/kotlin/fir/builder/CharacterWithDiagnostic;", "text", "", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "qualifiedSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "calleeReferenceSource", "name", "Lorg/jetbrains/kotlin/name/Name;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "generateResolvedAccessExpression", "source", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "processLegacyContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "translateEscape", "c", "", "appliesToPrimaryConstructorParameter", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "asReceiverParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "checkReceiver", "convertToReceiverParameter", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "createConventionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "operationReferenceSource", "baseSource", "argument", "conventionName", "createSafeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "receiver", "filterUseSiteTarget", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "target", "generateAccessorsByDelegate", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;", "delegateBuilder", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "isExtension", "lazyDelegateExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLazyExpression;", "generateComparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "operatorToken", "Lcom/intellij/psi/tree/IElementType;", "generateContainsOperation", "inverted", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "other", "isAnd", "generateNotNullOrOther", "Lorg/jetbrains/kotlin/fir/expressions/FirElvisExpression;", "initContainingClassAttr", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "isContractBlockFirCheck", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "isContractPresentFirCheck", "parseCharacter", "pullUpSafeCallIfNecessary", "toBinaryName", "toFirOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "toFirOperationOrNull", "toLegacyRawContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirLegacyRawContractDescription;", "toUnaryName", "raw-fir.common"})
@SourceDebugExtension(value={"SMAP\nConversionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversionUtils.kt\norg/jetbrains/kotlin/fir/builder/ConversionUtilsKt\n+ 2 FirElvisExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElvisExpressionBuilderKt\n+ 3 FirBinaryLogicExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirBinaryLogicExpressionBuilderKt\n+ 4 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 5 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n+ 6 FirComparisonExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirComparisonExpressionBuilderKt\n+ 7 FirPropertyAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirPropertyAccessExpressionBuilderKt\n+ 8 FirResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedNamedReferenceBuilderKt\n+ 9 FirPropertyAccessorBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirPropertyAccessorBuilderKt\n+ 10 FirReturnExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirReturnExpressionBuilderKt\n+ 11 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 12 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 13 FirLegacyRawContractDescriptionBuilder.kt\norg/jetbrains/kotlin/fir/contracts/builder/FirLegacyRawContractDescriptionBuilderKt\n+ 14 FirCheckedSafeCallSubjectBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCheckedSafeCallSubjectBuilderKt\n+ 15 FirSafeCallExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSafeCallExpressionBuilderKt\n+ 16 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 17 FirAnnotationCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationCallBuilderKt\n+ 18 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 19 FirReceiverParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirReceiverParameterBuilderKt\n+ 20 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 21 FirThisReceiverExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThisReceiverExpressionBuilderKt\n+ 22 FirImplicitThisReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirImplicitThisReferenceBuilderKt\n+ 23 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 24 FirDelegateFieldReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirDelegateFieldReferenceBuilderKt\n+ 25 FirCallableReferenceAccessBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCallableReferenceAccessBuilderKt\n+ 26 FirTypeProjectionWithVarianceBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirTypeProjectionWithVarianceBuilderKt\n*L\n1#1,676:1\n60#2,4:677\n59#3,4:681\n73#4,4:685\n73#4,4:697\n73#4,4:721\n73#4,4:737\n73#4,4:753\n41#5,4:689\n41#5,4:701\n41#5,4:709\n41#5,4:725\n41#5,4:741\n41#5,4:757\n57#6,4:693\n68#7,4:705\n68#7,4:713\n68#7,4:765\n68#7,4:844\n42#8,4:717\n42#8,4:769\n42#8,4:856\n103#9,4:729\n103#9,4:745\n60#10,4:733\n100#11,4:749\n33#12,4:761\n39#13,4:773\n50#14,4:777\n56#15,4:781\n1603#16,9:785\n1855#16:794\n1856#16:809\n1612#16:810\n819#16:815\n847#16,2:816\n1620#16,2:860\n1622#16:870\n83#17,13:795\n1#18:808\n44#19,4:811\n44#19,4:818\n1064#20,2:822\n82#21,4:824\n82#21,4:832\n39#22,4:828\n39#22,4:836\n51#23,4:840\n51#23,4:866\n40#24,4:848\n67#25,4:852\n42#26,4:862\n*S KotlinDebug\n*F\n+ 1 ConversionUtils.kt\norg/jetbrains/kotlin/fir/builder/ConversionUtilsKt\n*L\n183#1:677,4\n193#1:681,4\n210#1:685,4\n259#1:697,4\n408#1:721,4\n440#1:737,4\n495#1:753,4\n212#1:689,4\n261#1:701,4\n279#1:709,4\n410#1:725,4\n443#1:741,4\n498#1:757,4\n246#1:693,4\n277#1:705,4\n292#1:713,4\n505#1:765,4\n361#1:844,4\n294#1:717,4\n506#1:769,4\n374#1:856,4\n427#1:729,4\n468#1:745,4\n439#1:733,4\n478#1:749,4\n502#1:761,4\n536#1:773,4\n572#1:777,4\n581#1:781,4\n606#1:785,9\n606#1:794\n606#1:809\n606#1:810\n620#1:815\n620#1:816,2\n396#1:860,2\n396#1:870\n608#1:795,13\n606#1:808\n616#1:811,4\n628#1:818,4\n642#1:822,2\n343#1:824,4\n349#1:832,4\n345#1:828,4\n351#1:836,4\n354#1:840,4\n400#1:866,4\n363#1:848,4\n372#1:852,4\n397#1:862,4\n*E\n"})
public final class ConversionUtilsKt {
    @NotNull
    public static final CharacterWithDiagnostic parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkNotNullParameter($this$parseCharacter, "<this>");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return new CharacterWithDiagnostic(DiagnosticKind.IncorrectCharacterLiteral);
        }
        String string2 = $this$parseCharacter.substring(1, $this$parseCharacter.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String text2 = string2;
        if (((CharSequence)text2).length() == 0) {
            return new CharacterWithDiagnostic(DiagnosticKind.EmptyCharacterLiteral);
        }
        return text2.charAt(0) != '\\' ? (text2.length() == 1 ? new CharacterWithDiagnostic(text2.charAt(0)) : new CharacterWithDiagnostic(DiagnosticKind.TooManyCharactersInCharacterLiteral)) : ConversionUtilsKt.escapedStringToCharacter(text2);
    }

    @NotNull
    public static final CharacterWithDiagnostic escapedStringToCharacter(@NotNull String text2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(text2, "text");
        boolean bl2 = bl = ((CharSequence)text2).length() > 0 && text2.charAt(0) == '\\';
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Only escaped sequences must be passed to this routine: " + text2;
            throw new AssertionError((Object)string2);
        }
        String string3 = text2.substring(1);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        String escape = string3;
        switch (escape.length()) {
            case 0: {
                return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
            }
            case 1: {
                return ConversionUtilsKt.translateEscape(escape.charAt(0));
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                String string4 = escape.substring(1);
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                Integer intValue = StringsKt.toIntOrNull(string4, 16);
                if (intValue == null) break;
                return new CharacterWithDiagnostic((char)intValue.intValue());
            }
        }
        return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
    }

    @NotNull
    public static final CharacterWithDiagnostic translateEscape(char c) {
        char c2 = c;
        return c2 == 't' ? new CharacterWithDiagnostic('\t') : (c2 == 'b' ? new CharacterWithDiagnostic('\b') : (c2 == 'n' ? new CharacterWithDiagnostic('\n') : (c2 == 'r' ? new CharacterWithDiagnostic('\r') : (c2 == '\'' ? new CharacterWithDiagnostic('\'') : (c2 == '\"' ? new CharacterWithDiagnostic('\"') : (c2 == '\\' ? new CharacterWithDiagnostic('\\') : (c2 == '$' ? new CharacterWithDiagnostic('$') : new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape))))))));
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkNotNullParameter($this$toBinaryName, "<this>");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, "BINARY_OPERATION_NAMES");
        return (Name)((Map)immutableBiMap).get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkNotNullParameter($this$toUnaryName, "<this>");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, "UNARY_OPERATION_NAMES");
        return (Name)((Map)immutableBiMap).get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        Intrinsics.checkNotNullParameter($this$toFirOperation, "<this>");
        FirOperation firOperation = ConversionUtilsKt.toFirOperationOrNull($this$toFirOperation);
        if (firOperation == null) {
            throw new IllegalStateException(("Cannot convert element type to FIR operation: " + $this$toFirOperation).toString());
        }
        return firOperation;
    }

    @Nullable
    public static final FirOperation toFirOperationOrNull(@NotNull IElementType $this$toFirOperationOrNull) {
        Intrinsics.checkNotNullParameter($this$toFirOperationOrNull, "<this>");
        IElementType iElementType = $this$toFirOperationOrNull;
        return Intrinsics.areEqual(iElementType, KtTokens.LT) ? FirOperation.LT : (Intrinsics.areEqual(iElementType, KtTokens.GT) ? FirOperation.GT : (Intrinsics.areEqual(iElementType, KtTokens.LTEQ) ? FirOperation.LT_EQ : (Intrinsics.areEqual(iElementType, KtTokens.GTEQ) ? FirOperation.GT_EQ : (Intrinsics.areEqual(iElementType, KtTokens.EQEQ) ? FirOperation.EQ : (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ) ? FirOperation.NOT_EQ : (Intrinsics.areEqual(iElementType, KtTokens.EQEQEQ) ? FirOperation.IDENTITY : (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQEQEQ) ? FirOperation.NOT_IDENTITY : (Intrinsics.areEqual(iElementType, KtTokens.EQ) ? FirOperation.ASSIGN : (Intrinsics.areEqual(iElementType, KtTokens.PLUSEQ) ? FirOperation.PLUS_ASSIGN : (Intrinsics.areEqual(iElementType, KtTokens.MINUSEQ) ? FirOperation.MINUS_ASSIGN : (Intrinsics.areEqual(iElementType, KtTokens.MULTEQ) ? FirOperation.TIMES_ASSIGN : (Intrinsics.areEqual(iElementType, KtTokens.DIVEQ) ? FirOperation.DIV_ASSIGN : (Intrinsics.areEqual(iElementType, KtTokens.PERCEQ) ? FirOperation.REM_ASSIGN : (Intrinsics.areEqual(iElementType, KtTokens.AS_KEYWORD) ? FirOperation.AS : (Intrinsics.areEqual(iElementType, KtTokens.AS_SAFE) ? FirOperation.SAFE_AS : null)))))))))))))));
    }

    @NotNull
    public static final FirElvisExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirExpression other, @Nullable KtSourceElement baseSource) {
        FirElvisExpressionBuilder firElvisExpressionBuilder;
        Intrinsics.checkNotNullParameter($this$generateNotNullOrOther, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        boolean $i$f$buildElvisExpression = false;
        FirElvisExpressionBuilder $this$generateNotNullOrOther_u24lambda_u241 = firElvisExpressionBuilder = new FirElvisExpressionBuilder();
        boolean bl = false;
        $this$generateNotNullOrOther_u24lambda_u241.setSource(baseSource);
        $this$generateNotNullOrOther_u24lambda_u241.setLhs($this$generateNotNullOrOther);
        $this$generateNotNullOrOther_u24lambda_u241.setRhs(other);
        return firElvisExpressionBuilder.build();
    }

    @NotNull
    public static final FirBinaryLogicExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other, boolean isAnd, @Nullable KtSourceElement baseSource) {
        FirBinaryLogicExpressionBuilder firBinaryLogicExpressionBuilder;
        Intrinsics.checkNotNullParameter($this$generateLazyLogicalOperation, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        boolean $i$f$buildBinaryLogicExpression = false;
        FirBinaryLogicExpressionBuilder $this$generateLazyLogicalOperation_u24lambda_u242 = firBinaryLogicExpressionBuilder = new FirBinaryLogicExpressionBuilder();
        boolean bl = false;
        $this$generateLazyLogicalOperation_u24lambda_u242.setSource(baseSource);
        $this$generateLazyLogicalOperation_u24lambda_u242.setLeftOperand($this$generateLazyLogicalOperation);
        $this$generateLazyLogicalOperation_u24lambda_u242.setRightOperand(other);
        $this$generateLazyLogicalOperation_u24lambda_u242.setKind(isAnd ? LogicOperationKind.AND : LogicOperationKind.OR);
        return firBinaryLogicExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument2, boolean inverted, @Nullable KtSourceElement baseSource, @Nullable KtSourceElement operationReferenceSource) {
        void $this$generateContainsOperation_u24lambda_u244_u24lambda_u243;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Intrinsics.checkNotNullParameter($this$generateContainsOperation, "<this>");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        FirFunctionCall containsCall = ConversionUtilsKt.createConventionCall($this$generateContainsOperation, operationReferenceSource, baseSource, argument2, OperatorNameConventions.CONTAINS);
        if (!inverted) {
            return containsCall;
        }
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$generateContainsOperation_u24lambda_u244 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = baseSource;
        $this$generateContainsOperation_u24lambda_u244.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.DesugaredInvertedContains.INSTANCE, 0, 0, 6, null) : null);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$generateContainsOperation_u24lambda_u244;
        boolean bl2 = false;
        KtSourceElement ktSourceElement2 = operationReferenceSource;
        $this$generateContainsOperation_u24lambda_u244_u24lambda_u243.setSource(ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.DesugaredInvertedContains.INSTANCE, 0, 0, 6, null) : null);
        $this$generateContainsOperation_u24lambda_u244_u24lambda_u243.setName(OperatorNameConventions.NOT);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$generateContainsOperation_u24lambda_u244.setExplicitReceiver(containsCall);
        $this$generateContainsOperation_u24lambda_u244.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    @NotNull
    public static final FirComparisonExpression generateComparisonExpression(@NotNull FirExpression $this$generateComparisonExpression, @NotNull FirExpression argument2, @NotNull IElementType operatorToken, @Nullable KtSourceElement baseSource, @Nullable KtSourceElement operationReferenceSource) {
        FirComparisonExpressionBuilder firComparisonExpressionBuilder;
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter($this$generateComparisonExpression, "<this>");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Intrinsics.checkNotNullParameter(operatorToken, "operatorToken");
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, "COMPARISON_OPERATIONS");
        if (!CollectionsKt.contains((Iterable)immutableSet, operatorToken)) {
            boolean $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = false;
            String $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = operatorToken + " is not in " + OperatorConventions.COMPARISON_OPERATIONS;
            throw new IllegalArgumentException($i$a$-require-ConversionUtilsKt$generateComparisonExpression$22.toString());
        }
        KtSourceElement ktSourceElement = baseSource;
        FirFunctionCall compareToCall = ConversionUtilsKt.createConventionCall($this$generateComparisonExpression, operationReferenceSource, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.GeneratedComparisonExpression.INSTANCE, 0, 0, 6, null) : null, argument2, OperatorNameConventions.COMPARE_TO);
        IElementType iElementType = operatorToken;
        if (Intrinsics.areEqual(iElementType, KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else {
            throw new IllegalStateException(("Unknown " + operatorToken).toString());
        }
        FirOperation firOperation2 = firOperation;
        boolean $i$f$buildComparisonExpression = false;
        FirComparisonExpressionBuilder $this$generateComparisonExpression_u24lambda_u246 = firComparisonExpressionBuilder = new FirComparisonExpressionBuilder();
        boolean bl = false;
        $this$generateComparisonExpression_u24lambda_u246.setSource(baseSource);
        $this$generateComparisonExpression_u24lambda_u246.setOperation(firOperation2);
        $this$generateComparisonExpression_u24lambda_u246.setCompareToCall(compareToCall);
        return firComparisonExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirFunctionCall createConventionCall(FirExpression $this$createConventionCall, KtSourceElement operationReferenceSource, KtSourceElement baseSource, FirExpression argument2, Name conventionName) {
        void $this$createConventionCall_u24lambda_u248_u24lambda_u247;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$createConventionCall_u24lambda_u248 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        $this$createConventionCall_u24lambda_u248.setSource(baseSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$createConventionCall_u24lambda_u248;
        boolean bl2 = false;
        $this$createConventionCall_u24lambda_u248_u24lambda_u247.setSource(operationReferenceSource);
        $this$createConventionCall_u24lambda_u248_u24lambda_u247.setName(conventionName);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$createConventionCall_u24lambda_u248.setExplicitReceiver($this$createConventionCall);
        $this$createConventionCall_u24lambda_u248.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(argument2));
        $this$createConventionCall_u24lambda_u248.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@Nullable KtSourceElement qualifiedSource, @Nullable KtSourceElement calleeReferenceSource, @NotNull Name name2, @Nullable ConeDiagnostic diagnostic) {
        void $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249;
        KtSourceElement ktSourceElement;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter(name2, "name");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessExpression_u24lambda_u2410 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateAccessExpression_u24lambda_u2410.setSource(qualifiedSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessExpression_u24lambda_u2410;
        boolean bl2 = false;
        if (Intrinsics.areEqual(calleeReferenceSource, qualifiedSource)) {
            KtSourceElement ktSourceElement2 = calleeReferenceSource;
            ktSourceElement = ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE, 0, 0, 6, null) : null;
        } else {
            ktSourceElement = calleeReferenceSource;
        }
        $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249.setSource(ktSourceElement);
        $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249.setName(name2);
        firPropertyAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        if (diagnostic != null) {
            $this$generateAccessExpression_u24lambda_u2410.getNonFatalDiagnostics().add(diagnostic);
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    public static /* synthetic */ FirQualifiedAccessExpression generateAccessExpression$default(KtSourceElement ktSourceElement, KtSourceElement ktSourceElement2, Name name2, ConeDiagnostic coneDiagnostic, int n, Object object) {
        if ((n & 8) != 0) {
            coneDiagnostic = null;
        }
        return ConversionUtilsKt.generateAccessExpression(ktSourceElement, ktSourceElement2, name2, coneDiagnostic);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable KtSourceElement source, @NotNull FirVariable variable2) {
        void $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter(variable2, "variable");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateResolvedAccessExpression_u24lambda_u2412 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateResolvedAccessExpression_u24lambda_u2412.setSource(source);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateResolvedAccessExpression_u24lambda_u2412;
        boolean bl2 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setSource(source);
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setName(variable2.getName());
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setResolvedSymbol((FirBasedSymbol)variable2.getSymbol());
        firPropertyAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firPropertyAccessExpressionBuilder.build();
    }

    @Nullable
    public static final FirClassSymbol<? extends FirClass> getOwnerRegularOrAnonymousObjectSymbol(@NotNull FirClassBuilder $this$ownerRegularOrAnonymousObjectSymbol) {
        Intrinsics.checkNotNullParameter($this$ownerRegularOrAnonymousObjectSymbol, "<this>");
        FirClassBuilder firClassBuilder = $this$ownerRegularOrAnonymousObjectSymbol;
        return firClassBuilder instanceof FirAnonymousObjectBuilder ? (FirClassSymbol)((FirAnonymousObjectBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : (firClassBuilder instanceof FirRegularClassBuilder ? (FirClassSymbol)((FirRegularClassBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : null);
    }

    @Nullable
    public static final Integer getOwnerRegularClassTypeParametersCount(@NotNull FirClassBuilder $this$ownerRegularClassTypeParametersCount) {
        Intrinsics.checkNotNullParameter($this$ownerRegularClassTypeParametersCount, "<this>");
        return $this$ownerRegularClassTypeParametersCount instanceof FirRegularClassBuilder ? Integer.valueOf($this$ownerRegularClassTypeParametersCount.getTypeParameters().size()) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> void generateAccessorsByDelegate(@NotNull FirPropertyBuilder $this$generateAccessorsByDelegate, @Nullable FirWrappedDelegateExpressionBuilder delegateBuilder, @NotNull FirModuleData moduleData, @Nullable FirClassSymbol<?> ownerRegularOrAnonymousObjectSymbol, @NotNull Context<T> context2, boolean isExtension, @Nullable FirLazyExpression lazyDelegateExpression2) {
        Object it;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Object object;
        Object object2;
        Object object3;
        Object $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429;
        List<FirAnnotation> annotations2;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        Object object4;
        Object $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        FirPropertyBuilder firPropertyBuilder;
        FirExpression firExpression2;
        FirDelegateFieldSymbol firDelegateFieldSymbol;
        Intrinsics.checkNotNullParameter($this$generateAccessorsByDelegate, "<this>");
        Intrinsics.checkNotNullParameter(moduleData, "moduleData");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (delegateBuilder == null) {
            return;
        }
        FirDelegateFieldSymbol it2 = firDelegateFieldSymbol = new FirDelegateFieldSymbol($this$generateAccessorsByDelegate.getSymbol().getCallableId());
        boolean bl = false;
        $this$generateAccessorsByDelegate.setDelegateFieldSymbol(it2);
        FirDelegateFieldSymbol delegateFieldSymbol = firDelegateFieldSymbol;
        boolean isMember = ownerRegularOrAnonymousObjectSymbol != null;
        KtSourceElement ktSourceElement = delegateBuilder.getSource();
        KtSourceElement fakeSource = ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null) : null;
        boolean isVar = $this$generateAccessorsByDelegate.isVar();
        FirPropertyBuilder firPropertyBuilder2 = $this$generateAccessorsByDelegate;
        FirLazyExpression firLazyExpression = lazyDelegateExpression2;
        if (firLazyExpression != null) {
            firExpression2 = firLazyExpression;
        } else {
            void $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426;
            FirFunctionCallBuilder firFunctionCallBuilder;
            FirPropertyBuilder firPropertyBuilder3 = $this$generateAccessorsByDelegate;
            firPropertyBuilder = firPropertyBuilder2;
            boolean bl2 = false;
            boolean $i$f$buildFunctionCall = false;
            FirFunctionCallBuilder firFunctionCallBuilder2 = firFunctionCallBuilder = new FirFunctionCallBuilder();
            firAnnotationContainerBuilder = delegateBuilder;
            boolean bl3 = false;
            ((FirFunctionCallBuilder)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427).setExplicitReceiver(delegateBuilder.getExpression());
            boolean $i$f$buildSimpleNamedReference = false;
            object4 = new FirSimpleNamedReferenceBuilder();
            firSimpleNamedReferenceBuilder = object4;
            void var22_35 = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
            boolean bl4 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setName(OperatorNameConventions.PROVIDE_DELEGATE);
            var22_35.setCalleeReference(((FirSimpleNamedReferenceBuilder)object4).build());
            ((FirFunctionCallBuilder)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427).setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context2, true), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            ((FirFunctionCallBuilder)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427).setOrigin(FirFunctionCallOrigin.Operator);
            ((FirFunctionCallBuilder)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427).setSource(fakeSource);
            ((FirWrappedDelegateExpressionBuilder)firAnnotationContainerBuilder).setDelegateProvider(firFunctionCallBuilder.build());
            firPropertyBuilder2 = firPropertyBuilder;
            firExpression2 = delegateBuilder.build();
        }
        firPropertyBuilder2.setDelegate(firExpression2);
        if ($this$generateAccessorsByDelegate.getGetter() == null || $this$generateAccessorsByDelegate.getGetter() instanceof FirDefaultPropertyAccessor) {
            void $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430;
            void $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431;
            void $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432;
            void $this$generateAccessorsByDelegate_u24lambda_u2433;
            FirPropertyAccessor firPropertyAccessor = $this$generateAccessorsByDelegate.getGetter();
            annotations2 = firPropertyAccessor != null ? firPropertyAccessor.getAnnotations() : null;
            FirFunctionTarget returnTarget = new FirFunctionTarget(null, false);
            FirPropertyAccessor firPropertyAccessor2 = $this$generateAccessorsByDelegate.getGetter();
            FirDeclarationStatus getterStatus = firPropertyAccessor2 != null ? firPropertyAccessor2.getStatus() : null;
            Object object5 = $this$generateAccessorsByDelegate.getGetter();
            if (object5 == null || (object5 = ((FirPropertyAccessor)object5).getSource()) == null || (object5 = KtSourceElementKt.fakeElement$default((KtSourceElement)object5, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) == null) {
                object5 = fakeSource;
            }
            Object getterElement = object5;
            boolean $i$f$buildPropertyAccessor22 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427 = new FirPropertyAccessorBuilder();
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
            firPropertyBuilder = $this$generateAccessorsByDelegate;
            boolean bl5 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2433.setSource((KtSourceElement)getterElement);
            $this$generateAccessorsByDelegate_u24lambda_u2433.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2433.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2433.setReturnTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2433.setGetter(true);
            Object object6 = getterStatus;
            if (object6 == null || (object6 = object6.getVisibility()) == null) {
                object6 = Visibilities.Unknown.INSTANCE;
            }
            FirDeclarationStatusImpl $i$f$buildSimpleNamedReference = new FirDeclarationStatusImpl((Visibility)object6, Modality.FINAL);
            object4 = $i$f$buildSimpleNamedReference;
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2433;
            boolean $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$2$22 = false;
            FirDeclarationStatus firDeclarationStatus = getterStatus;
            ((FirDeclarationStatusImpl)$this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429).setInline(firDeclarationStatus != null ? firDeclarationStatus.isInline() : ((FirDeclarationStatusImpl)$this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429).isInline());
            ((FirPropertyAccessorBuilder)((Object)firSimpleNamedReferenceBuilder)).setStatus($i$f$buildSimpleNamedReference);
            $this$generateAccessorsByDelegate_u24lambda_u2433.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildReturnExpression = false;
            Object $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$2$22 = $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429 = new FirReturnExpressionBuilder();
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2433;
            boolean bl6 = false;
            boolean $i$f$buildFunctionCall = false;
            FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
            object3 = firFunctionCallBuilder;
            object2 = $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432;
            boolean bl7 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, context2));
            boolean $i$f$buildSimpleNamedReference2 = false;
            object = new FirSimpleNamedReferenceBuilder();
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = object;
            firPropertyAccessExpressionBuilder = $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431;
            boolean bl8 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430.setName(OperatorNameConventions.GET_VALUE);
            ((FirFunctionCallBuilder)((Object)firPropertyAccessExpressionBuilder)).setCalleeReference(((FirSimpleNamedReferenceBuilder)object).build());
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context2, false, 32, null), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setOrigin(FirFunctionCallOrigin.Operator);
            ((FirReturnExpressionBuilder)object2).setResult(firFunctionCallBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432.setTarget(returnTarget);
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2432.setSource(fakeSource);
            FirStatement firStatement = ((FirReturnExpressionBuilder)$this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429).build();
            ((FirPropertyAccessorBuilder)((Object)firSimpleNamedReferenceBuilder)).setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations2 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2433.getAnnotations().addAll((Collection<FirAnnotation>)annotations2);
            }
            $this$generateAccessorsByDelegate_u24lambda_u2433.setPropertySymbol($this$generateAccessorsByDelegate.getSymbol());
            FirPropertyAccessor $i$f$buildPropertyAccessor22 = ((FirPropertyAccessorBuilder)$this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427).build();
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427 = $i$f$buildPropertyAccessor22;
            boolean bl9 = false;
            returnTarget.bind((FirTargetElement)it);
            ConversionUtilsKt.initContainingClassAttr((FirCallableDeclaration)it, context2);
            firPropertyBuilder.setGetter($i$f$buildPropertyAccessor22);
        }
        if (isVar && ($this$generateAccessorsByDelegate.getSetter() == null || $this$generateAccessorsByDelegate.getSetter() instanceof FirDefaultPropertyAccessor)) {
            void $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439_u24lambda_u2438;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
            void $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440;
            Object $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2437;
            void $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441;
            void $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2435;
            void $this$generateAccessorsByDelegate_u24lambda_u2442;
            FirPropertyAccessor firPropertyAccessor = $this$generateAccessorsByDelegate.getSetter();
            annotations2 = firPropertyAccessor != null ? firPropertyAccessor.getAnnotations() : null;
            Object object7 = $this$generateAccessorsByDelegate.getSetter();
            List<FirAnnotation> parameterAnnotations = object7 != null && (object7 = ((FirPropertyAccessor)object7).getValueParameters()) != null && (object7 = (FirValueParameter)CollectionsKt.firstOrNull(object7)) != null ? ((FirValueParameter)object7).getAnnotations() : null;
            FirPropertyAccessor firPropertyAccessor3 = $this$generateAccessorsByDelegate.getSetter();
            FirDeclarationStatus setterStatus = firPropertyAccessor3 != null ? firPropertyAccessor3.getStatus() : null;
            Object object8 = $this$generateAccessorsByDelegate.getSetter();
            if (object8 == null || (object8 = ((FirPropertyAccessor)object8).getSource()) == null || (object8 = KtSourceElementKt.fakeElement$default((KtSourceElement)object8, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) == null) {
                object8 = fakeSource;
            }
            Object setterElement = object8;
            boolean $i$f$buildPropertyAccessor = false;
            it = new FirPropertyAccessorBuilder();
            FirPropertyAccessorBuilder bl9 = it;
            firPropertyBuilder = $this$generateAccessorsByDelegate;
            boolean bl10 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2442.setSource((KtSourceElement)setterElement);
            $this$generateAccessorsByDelegate_u24lambda_u2442.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2442.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2442.setReturnTypeRef(moduleData.getSession().getBuiltinTypes().getUnitType());
            $this$generateAccessorsByDelegate_u24lambda_u2442.setGetter(false);
            Object object9 = setterStatus;
            if (object9 == null || (object9 = object9.getVisibility()) == null) {
                object9 = Visibilities.Unknown.INSTANCE;
            }
            FirDeclarationStatusImpl $i$f$buildReturnExpression = new FirDeclarationStatusImpl((Visibility)object9, Modality.FINAL);
            $this$generateAccessorsByDelegate_u24lambda_u2433_u24lambda_u2429 = $i$f$buildReturnExpression;
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2442;
            boolean bl11 = false;
            FirDeclarationStatus firDeclarationStatus = setterStatus;
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2435.setInline(firDeclarationStatus != null ? firDeclarationStatus.isInline() : $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2435.isInline());
            ((FirPropertyAccessorBuilder)((Object)firSimpleNamedReferenceBuilder)).setStatus($i$f$buildReturnExpression);
            $this$generateAccessorsByDelegate_u24lambda_u2442.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildValueParameter = false;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder2 = new FirValueParameterBuilder();
            FirValueParameterBuilder $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436 = firAnnotationContainerBuilder2;
            boolean bl12 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.setContainingFunctionSymbol($this$generateAccessorsByDelegate_u24lambda_u2442.getSymbol());
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.setReturnTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.setName(SpecialNames.IMPLICIT_SET_PARAMETER);
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.setSymbol(new FirValueParameterSymbol($this$generateAccessorsByDelegate.getName()));
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.setCrossinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.setNoinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.setVararg(false);
            if (parameterAnnotations != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436.getAnnotations().addAll((Collection<FirAnnotation>)parameterAnnotations);
            }
            FirValueParameter parameter2 = ((FirValueParameterBuilder)firAnnotationContainerBuilder2).build();
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2442.getValueParameters()).add(parameter2);
            boolean $i$f$buildFunctionCall = false;
            firAnnotationContainerBuilder2 = new FirFunctionCallBuilder();
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2436 = firAnnotationContainerBuilder2;
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2442;
            boolean bl13 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, context2));
            boolean $i$f$buildSimpleNamedReference = false;
            object2 = object3 = new FirSimpleNamedReferenceBuilder();
            void var30_49 = $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441;
            boolean bl14 = false;
            ((FirSimpleNamedReferenceBuilder)$this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2437).setSource(fakeSource);
            ((FirSimpleNamedReferenceBuilder)$this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2437).setName(OperatorNameConventions.SET_VALUE);
            var30_49.setCalleeReference(((FirSimpleNamedReferenceBuilder)object3).build());
            boolean $i$f$buildArgumentList = false;
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2437 = object3 = new FirArgumentListBuilder();
            var30_49 = $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441;
            boolean bl15 = false;
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440.getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context2, false, 32, null));
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440.getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate));
            object = $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440.getArguments();
            boolean $i$f$buildPropertyAccessExpression = false;
            FirPropertyAccessExpressionBuilder $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
            boolean bl16 = false;
            boolean $i$f$buildResolvedNamedReference = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
            FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439;
            boolean bl17 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439_u24lambda_u2438.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439_u24lambda_u2438.setName(SpecialNames.IMPLICIT_SET_PARAMETER);
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439_u24lambda_u2438.setResolvedSymbol(parameter2.getSymbol());
            firPropertyAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
            FirPropertyAccessExpression firPropertyAccessExpression = firPropertyAccessExpressionBuilder.build();
            object.add(firPropertyAccessExpression);
            var30_49.setArgumentList(((FirArgumentListBuilder)object3).build());
            $this$generateAccessorsByDelegate_u24lambda_u2442_u24lambda_u2441.setOrigin(FirFunctionCallOrigin.Operator);
            FirStatement firStatement = ((FirFunctionCallBuilder)firAnnotationContainerBuilder2).build();
            ((FirPropertyAccessorBuilder)((Object)firSimpleNamedReferenceBuilder)).setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations2 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2442.getAnnotations().addAll((Collection<FirAnnotation>)annotations2);
            }
            $this$generateAccessorsByDelegate_u24lambda_u2442.setPropertySymbol($this$generateAccessorsByDelegate.getSymbol());
            FirPropertyAccessor firPropertyAccessor4 = ((FirPropertyAccessorBuilder)it).build();
            it = firPropertyAccessor4;
            boolean bl18 = false;
            ConversionUtilsKt.initContainingClassAttr((FirCallableDeclaration)it, context2);
            firPropertyBuilder.setSetter(firPropertyAccessor4);
        }
    }

    public static /* synthetic */ void generateAccessorsByDelegate$default(FirPropertyBuilder firPropertyBuilder, FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder, FirModuleData firModuleData, FirClassSymbol firClassSymbol, Context context2, boolean bl, FirLazyExpression firLazyExpression, int n, Object object) {
        if ((n & 0x20) != 0) {
            firLazyExpression = null;
        }
        ConversionUtilsKt.generateAccessorsByDelegate(firPropertyBuilder, firWrappedDelegateExpressionBuilder, firModuleData, firClassSymbol, context2, bl, firLazyExpression);
    }

    @Nullable
    public static final FirContractDescription processLegacyContractDescription(@NotNull FirBlock block) {
        Intrinsics.checkNotNullParameter(block, "block");
        if (ConversionUtilsKt.isContractPresentFirCheck(block)) {
            FirFunctionCall contractCall2 = (FirFunctionCall)FirExpressionUtilKt.replaceFirstStatement(block, processLegacyContractDescription.contractCall.1.INSTANCE);
            return ConversionUtilsKt.toLegacyRawContractDescription(contractCall2);
        }
        return null;
    }

    @NotNull
    public static final FirLegacyRawContractDescription toLegacyRawContractDescription(@NotNull FirFunctionCall $this$toLegacyRawContractDescription) {
        FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder;
        Intrinsics.checkNotNullParameter($this$toLegacyRawContractDescription, "<this>");
        boolean $i$f$buildLegacyRawContractDescription = false;
        FirLegacyRawContractDescriptionBuilder $this$toLegacyRawContractDescription_u24lambda_u2444 = firLegacyRawContractDescriptionBuilder = new FirLegacyRawContractDescriptionBuilder();
        boolean bl = false;
        $this$toLegacyRawContractDescription_u24lambda_u2444.setSource($this$toLegacyRawContractDescription.getSource());
        $this$toLegacyRawContractDescription_u24lambda_u2444.setContractCall($this$toLegacyRawContractDescription);
        return firLegacyRawContractDescriptionBuilder.build();
    }

    public static final boolean isContractPresentFirCheck(@NotNull FirBlock $this$isContractPresentFirCheck) {
        Intrinsics.checkNotNullParameter($this$isContractPresentFirCheck, "<this>");
        FirStatement firStatement = CollectionsKt.firstOrNull($this$isContractPresentFirCheck.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement firstStatement = firStatement;
        return ConversionUtilsKt.isContractBlockFirCheck(firstStatement);
    }

    public static final boolean isContractBlockFirCheck(@NotNull FirStatement $this$isContractBlockFirCheck) {
        Intrinsics.checkNotNullParameter($this$isContractBlockFirCheck, "<this>");
        FirFunctionCall firFunctionCall = $this$isContractBlockFirCheck instanceof FirFunctionCall ? (FirFunctionCall)$this$isContractBlockFirCheck : null;
        if (firFunctionCall == null) {
            return false;
        }
        FirFunctionCall contractCall2 = firFunctionCall;
        if (!Intrinsics.areEqual(contractCall2.getCalleeReference().getName().asString(), "contract")) {
            return false;
        }
        FirExpression firExpression2 = contractCall2.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return true;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        if (!ConversionUtilsKt.checkReceiver(contractCall2, "contracts")) {
            return false;
        }
        if (!ConversionUtilsKt.checkReceiver(receiver, "kotlin")) {
            return false;
        }
        FirExpression firExpression3 = receiver.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firExpression3 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression3 : null;
        if (firQualifiedAccessExpression2 == null) {
            return false;
        }
        FirQualifiedAccessExpression receiverOfReceiver = firQualifiedAccessExpression2;
        return receiverOfReceiver.getExplicitReceiver() == null;
    }

    private static final boolean checkReceiver(FirExpression $this$checkReceiver, String name2) {
        if (!($this$checkReceiver instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$checkReceiver).getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        FirReference firReference = receiver.getCalleeReference();
        Object object = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
        if (object == null || (object = ((FirNamedReference)object).getName()) == null || (object = ((Name)object).asString()) == null) {
            return false;
        }
        Object receiverName = object;
        return Intrinsics.areEqual(receiverName, name2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirSafeCallExpression createSafeCall(@NotNull FirQualifiedAccessExpression $this$createSafeCall, @NotNull FirExpression receiver, @NotNull KtSourceElement source) {
        void $this$createSafeCall_u24lambda_u2449_u24lambda_u2448;
        FirExpressionRef<FirExpression> $this$createSafeCall_u24lambda_u2447_u24lambda_u2446;
        FirExpressionRef<FirExpression> firExpressionRef;
        Intrinsics.checkNotNullParameter($this$createSafeCall, "<this>");
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        Intrinsics.checkNotNullParameter(source, "source");
        boolean $i$f$buildCheckedSafeCallSubject = false;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder = new FirCheckedSafeCallSubjectBuilder();
        FirCheckedSafeCallSubjectBuilder $this$createSafeCall_u24lambda_u2447 = firAnnotationContainerBuilder;
        boolean bl = false;
        FirExpressionRef<FirExpression> firExpressionRef2 = firExpressionRef = new FirExpressionRef<FirExpression>();
        FirAnnotationContainerBuilder firAnnotationContainerBuilder2 = $this$createSafeCall_u24lambda_u2447;
        boolean bl2 = false;
        $this$createSafeCall_u24lambda_u2447_u24lambda_u2446.bind(receiver);
        ((FirCheckedSafeCallSubjectBuilder)firAnnotationContainerBuilder2).setOriginalReceiverRef(firExpressionRef);
        KtSourceElement ktSourceElement = receiver.getSource();
        $this$createSafeCall_u24lambda_u2447.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.CheckedSafeCallSubject.INSTANCE, 0, 0, 6, null) : null);
        FirCheckedSafeCallSubject checkedSafeCallSubject = ((FirCheckedSafeCallSubjectBuilder)firAnnotationContainerBuilder).build();
        $this$createSafeCall.replaceExplicitReceiver(checkedSafeCallSubject);
        boolean $i$f$buildSafeCallExpression = false;
        FirAnnotationContainerBuilder $this$createSafeCall_u24lambda_u2449 = firAnnotationContainerBuilder = new FirSafeCallExpressionBuilder();
        boolean bl3 = false;
        ((FirSafeCallExpressionBuilder)$this$createSafeCall_u24lambda_u2449).setReceiver(receiver);
        $this$createSafeCall_u24lambda_u2447_u24lambda_u2446 = firExpressionRef = new FirExpressionRef();
        firAnnotationContainerBuilder2 = $this$createSafeCall_u24lambda_u2449;
        boolean bl4 = false;
        $this$createSafeCall_u24lambda_u2449_u24lambda_u2448.bind((FirExpression)checkedSafeCallSubject);
        ((FirSafeCallExpressionBuilder)firAnnotationContainerBuilder2).setCheckedSubjectRef(firExpressionRef);
        ((FirSafeCallExpressionBuilder)$this$createSafeCall_u24lambda_u2449).setSelector($this$createSafeCall);
        ((FirSafeCallExpressionBuilder)$this$createSafeCall_u24lambda_u2449).setSource(source);
        return ((FirSafeCallExpressionBuilder)firAnnotationContainerBuilder).build();
    }

    @NotNull
    public static final FirExpression pullUpSafeCallIfNecessary(@NotNull FirExpression $this$pullUpSafeCallIfNecessary) {
        Intrinsics.checkNotNullParameter($this$pullUpSafeCallIfNecessary, "<this>");
        if (!($this$pullUpSafeCallIfNecessary instanceof FirQualifiedAccessExpression)) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$pullUpSafeCallIfNecessary).getExplicitReceiver();
        FirSafeCallExpression firSafeCallExpression = firExpression2 instanceof FirSafeCallExpression ? (FirSafeCallExpression)firExpression2 : null;
        if (firSafeCallExpression == null) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirSafeCallExpression safeCall = firSafeCallExpression;
        FirStatement firStatement = safeCall.getSelector();
        FirExpression firExpression3 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
        if (firExpression3 == null) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirExpression safeCallSelector = firExpression3;
        ((FirQualifiedAccessExpression)$this$pullUpSafeCallIfNecessary).replaceExplicitReceiver(safeCallSelector);
        safeCall.replaceSelector($this$pullUpSafeCallIfNecessary);
        return safeCall;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnnotationCall> filterUseSiteTarget(@NotNull List<? extends FirAnnotationCall> $this$filterUseSiteTarget, @NotNull AnnotationUseSiteTarget target) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterUseSiteTarget, "<this>");
        Intrinsics.checkNotNullParameter((Object)target, "target");
        Iterable $this$mapNotNull$iv = $this$filterUseSiteTarget;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirAnnotationCall firAnnotationCall;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
            boolean bl2 = false;
            if (it.getUseSiteTarget() != target) {
                firAnnotationCall = null;
            } else {
                FirAnnotationCallBuilder firAnnotationCallBuilder;
                boolean $i$f$buildAnnotationCallCopy = false;
                FirAnnotationCallBuilder copyBuilder$iv = new FirAnnotationCallBuilder();
                copyBuilder$iv.setSource(it.getSource());
                copyBuilder$iv.setUseSiteTarget(it.getUseSiteTarget());
                copyBuilder$iv.setAnnotationTypeRef(it.getAnnotationTypeRef());
                copyBuilder$iv.getTypeArguments().addAll((Collection<FirTypeProjection>)it.getTypeArguments());
                copyBuilder$iv.setArgumentList(it.getArgumentList());
                copyBuilder$iv.setCalleeReference(it.getCalleeReference());
                copyBuilder$iv.setArgumentMapping(it.getArgumentMapping());
                copyBuilder$iv.setAnnotationResolvePhase(it.getAnnotationResolvePhase());
                FirAnnotationCallBuilder $this$filterUseSiteTarget_u24lambda_u2451_u24lambda_u2450 = firAnnotationCallBuilder = copyBuilder$iv;
                boolean bl3 = false;
                KtSourceElement ktSourceElement = it.getSource();
                $this$filterUseSiteTarget_u24lambda_u2451_u24lambda_u2450.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.FromUseSiteTarget.INSTANCE, 0, 0, 6, null) : null);
                firAnnotationCall = firAnnotationCallBuilder.build();
            }
            if (firAnnotationCall == null) continue;
            FirAnnotationCall it$iv$iv = firAnnotationCall;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirReceiverParameter convertToReceiverParameter(@NotNull FirTypeRef $this$convertToReceiverParameter) {
        void $this$filterNotTo$iv$iv;
        FirReceiverParameterBuilder firReceiverParameterBuilder;
        Intrinsics.checkNotNullParameter($this$convertToReceiverParameter, "<this>");
        FirTypeRef typeRef = $this$convertToReceiverParameter;
        boolean $i$f$buildReceiverParameter = false;
        FirReceiverParameterBuilder $this$convertToReceiverParameter_u24lambda_u2453 = firReceiverParameterBuilder = new FirReceiverParameterBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = typeRef.getSource();
        $this$convertToReceiverParameter_u24lambda_u2453.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ReceiverFromType.INSTANCE, 0, 0, 6, null) : null);
        Collection collection = $this$convertToReceiverParameter_u24lambda_u2453.getAnnotations();
        List<FirAnnotation> list2 = typeRef.getAnnotations();
        Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlin.fir.expressions.FirAnnotationCall>");
        CollectionsKt.addAll(collection, (Iterable)ConversionUtilsKt.filterUseSiteTarget(list2, AnnotationUseSiteTarget.RECEIVER));
        Iterable $this$filterNot$iv = typeRef.getAnnotations();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirAnnotation it = (FirAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (it.getUseSiteTarget() == AnnotationUseSiteTarget.RECEIVER) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredTypeRefAnnotations = (List)destination$iv$iv;
        if (filteredTypeRefAnnotations.size() != typeRef.getAnnotations().size()) {
            typeRef.replaceAnnotations(filteredTypeRefAnnotations);
        }
        $this$convertToReceiverParameter_u24lambda_u2453.setTypeRef(typeRef);
        return firReceiverParameterBuilder.build();
    }

    @NotNull
    public static final FirReceiverParameter asReceiverParameter(@NotNull KtSourceElement $this$asReceiverParameter) {
        FirReceiverParameterBuilder firReceiverParameterBuilder;
        Intrinsics.checkNotNullParameter($this$asReceiverParameter, "<this>");
        boolean $i$f$buildReceiverParameter = false;
        FirReceiverParameterBuilder $this$asReceiverParameter_u24lambda_u2454 = firReceiverParameterBuilder = new FirReceiverParameterBuilder();
        boolean bl = false;
        $this$asReceiverParameter_u24lambda_u2454.setSource(KtSourceElementKt.fakeElement$default($this$asReceiverParameter, KtFakeSourceElementKind.ReceiverFromType.INSTANCE, 0, 0, 6, null));
        $this$asReceiverParameter_u24lambda_u2454.setTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
        return firReceiverParameterBuilder.build();
    }

    public static final <T> void initContainingClassAttr(@NotNull FirCallableDeclaration $this$initContainingClassAttr, @NotNull Context<T> context2) {
        Intrinsics.checkNotNullParameter($this$initContainingClassAttr, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object object = ConversionUtilsKt.currentDispatchReceiverType(context2);
        if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return;
        }
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$initContainingClassAttr, (ConeClassLikeLookupTag)object);
    }

    @Nullable
    public static final <T> ConeClassLikeType currentDispatchReceiverType(@NotNull Context<T> context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        return CollectionsKt.lastOrNull(context2.getDispatchReceiverTypesStack());
    }

    public static final boolean isUnderscore(@NotNull CharSequence $this$isUnderscore) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$isUnderscore, "<this>");
            CharSequence $this$all$iv = $this$isUnderscore;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (it == '_') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public static final FirExpression buildBalancedOrExpressionTree(@NotNull List<? extends FirExpression> conditions2, int lower2, int upper) {
        Intrinsics.checkNotNullParameter(conditions2, "conditions");
        int size = upper - lower2 + 1;
        int middle = size / 2 + lower2;
        if (lower2 == upper) {
            return conditions2.get(middle);
        }
        FirExpression leftNode = ConversionUtilsKt.buildBalancedOrExpressionTree(conditions2, lower2, middle - 1);
        FirExpression rightNode = ConversionUtilsKt.buildBalancedOrExpressionTree(conditions2, middle, upper);
        KtSourceElement ktSourceElement = leftNode.getSource();
        if (ktSourceElement == null) {
            ktSourceElement = rightNode.getSource();
        }
        return ConversionUtilsKt.generateLazyLogicalOperation(leftNode, rightNode, false, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.WhenCondition.INSTANCE, 0, 0, 6, null) : null);
    }

    public static /* synthetic */ FirExpression buildBalancedOrExpressionTree$default(List list2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = CollectionsKt.getLastIndex(list2);
        }
        return ConversionUtilsKt.buildBalancedOrExpressionTree(list2, n, n2);
    }

    public static final boolean appliesToPrimaryConstructorParameter(@Nullable AnnotationUseSiteTarget $this$appliesToPrimaryConstructorParameter) {
        return $this$appliesToPrimaryConstructorParameter == null || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.RECEIVER || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.FILE;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> FirExpression generateAccessorsByDelegate$thisRef(boolean $isExtension, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, KtSourceElement fakeSource, FirPropertyBuilder $this_generateAccessorsByDelegate, Context<T> $context, boolean forDispatchReceiver) {
        FirExpression firExpression2;
        if ($isExtension && !forDispatchReceiver) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415_u24lambda_u2414;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder2 = firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415;
            boolean bl2 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415_u24lambda_u2414.setBoundSymbol($this_generateAccessorsByDelegate.getSymbol());
            firThisReceiverExpressionBuilder2.setCalleeReference(firImplicitThisReferenceBuilder.build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else if ($ownerRegularOrAnonymousObjectSymbol != null) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2417;
            Object $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2416;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            Object object = new FirImplicitThisReferenceBuilder();
            FirImplicitThisReferenceBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415_u24lambda_u2414 = object;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418;
            boolean bl3 = false;
            ((FirImplicitThisReferenceBuilder)$this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2416).setBoundSymbol((FirBasedSymbol)$ownerRegularOrAnonymousObjectSymbol);
            firThisReceiverExpressionBuilder3.setCalleeReference(((FirImplicitThisReferenceBuilder)object).build());
            boolean $i$f$buildResolvedTypeRef = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2416 = object = new FirResolvedTypeRefBuilder();
            firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418;
            boolean bl4 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2417.setType(CollectionsKt.last($context.getDispatchReceiverTypesStack()));
            firThisReceiverExpressionBuilder3.setTypeRef(((FirResolvedTypeRefBuilder)object).build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else {
            firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Null.INSTANCE, null, null, false, 8, null);
        }
        return firExpression2;
    }

    static /* synthetic */ FirExpression generateAccessorsByDelegate$thisRef$default(boolean bl, FirClassSymbol firClassSymbol, KtSourceElement ktSourceElement, FirPropertyBuilder firPropertyBuilder, Context context2, boolean bl2, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        return ConversionUtilsKt.generateAccessorsByDelegate$thisRef(bl, firClassSymbol, ktSourceElement, firPropertyBuilder, context2, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> FirPropertyAccessExpression generateAccessorsByDelegate$delegateAccess(KtSourceElement fakeSource, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, FirDelegateFieldSymbol delegateFieldSymbol, boolean $isExtension, FirPropertyBuilder $this_generateAccessorsByDelegate, Context<T> $context) {
        void $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420.setSource(fakeSource);
        boolean $i$f$buildDelegateFieldReference = false;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder2 = firDelegateFieldReferenceBuilder = new FirDelegateFieldReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419.setResolvedSymbol(delegateFieldSymbol);
        firPropertyAccessExpressionBuilder2.setCalleeReference(firDelegateFieldReferenceBuilder.build());
        if ($ownerRegularOrAnonymousObjectSymbol != null) {
            $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420.setDispatchReceiver(ConversionUtilsKt.generateAccessorsByDelegate$thisRef($isExtension, $ownerRegularOrAnonymousObjectSymbol, fakeSource, $this_generateAccessorsByDelegate, $context, true));
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirCallableReferenceAccess generateAccessorsByDelegate$propertyRef(KtSourceElement fakeSource, boolean isMember, boolean $isExtension, boolean isVar, FirPropertyBuilder $this_generateAccessorsByDelegate) {
        void $this$mapTo$iv;
        void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder;
        boolean $i$f$buildCallableReferenceAccess = false;
        FirCallableReferenceAccessBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425 = firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
        boolean bl = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.setSource(fakeSource);
        boolean $i$f$buildResolvedNamedReference22 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        Object object = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setSource(fakeSource);
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setName($this_generateAccessorsByDelegate.getName());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setResolvedSymbol($this_generateAccessorsByDelegate.getSymbol());
        ((FirCallableReferenceAccessBuilder)object).setCalleeReference(firResolvedNamedReferenceBuilder.build());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.setTypeRef(!isMember && !$isExtension ? (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty0TypeRef(null, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty0TypeRef(null, ConeStarProjection.INSTANCE)) : (isMember && $isExtension ? (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE)) : (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE))));
        Iterable $i$f$buildResolvedNamedReference22 = $this_generateAccessorsByDelegate.getTypeParameters();
        Collection destination$iv = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.getTypeArguments();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv;
            object = destination$iv;
            boolean bl3 = false;
            boolean $i$f$buildTypeProjectionWithVariance = false;
            FirTypeProjectionWithVarianceBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423 = firTypeProjectionWithVarianceBuilder = new FirTypeProjectionWithVarianceBuilder();
            boolean bl4 = false;
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423.setVariance(Variance.INVARIANT);
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder2 = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423;
            boolean bl5 = false;
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.setType(new ConeTypeParameterTypeImpl(it.getSymbol().toLookupTag(), false, null, 4, null));
            firTypeProjectionWithVarianceBuilder2.setTypeRef(firResolvedTypeRefBuilder.build());
            object.add(firTypeProjectionWithVarianceBuilder.build());
        }
        return firCallableReferenceAccessBuilder.build();
    }
}

