/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.WasmTarget;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u001e\u0010\u001f\u001a\u00020\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0018\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0002J \u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0019H\u0002J\u0010\u00100\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u00190!*\u0002062\u0006\u0010/\u001a\u00020\u0019H\u0002J\f\u00107\u001a\u00020(*\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "jsToKotlinAnyAdapter", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getJsToKotlinAnyAdapter", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "kotlinToJsAnyAdapter", "getKotlinToJsAnyAdapter", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "eraseToClassOrInterface", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getEraseToClassOrInterface", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateIsExternalClass", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "argument", "klass", "generateIsInterface", "toType", "generateIsSubClass", "generateTypeCheck", "valueProvider", "Lkotlin/Function0;", "generateTypeCheckNonNull", "generateTypeCheckWithTypeParameter", "lowerCast", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "isSafe", "", "lowerImplicitCast", "lowerInstanceOf", "inverted", "lowerIntegerCoercion", "narrowType", "fromType", "value", "visitTypeOperator", "visitVariable", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "cacheValue", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "isInlined", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmTypeOperatorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmTypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n390#2,13:357\n390#2,13:372\n390#2,13:387\n390#2,13:402\n98#3,2:370\n98#3,2:385\n98#3,2:400\n98#3,2:415\n1789#4,3:417\n*S KotlinDebug\n*F\n+ 1 WasmTypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer\n*L\n80#1:357,13\n172#1:372,13\n243#1:387,13\n278#1:402,13\n80#1:370,2\n172#1:385,2\n243#1:400,2\n278#1:415,2\n311#1:417,3\n*E\n"})
public final class WasmBaseTypeOperatorTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final WasmSymbols symbols;
    @NotNull
    private final IrBuiltIns builtIns;
    private DeclarationIrBuilder builder;

    public WasmBaseTypeOperatorTransformer(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.symbols = this.context.getWasmSymbols();
        this.builtIns = this.context.getIrBuiltIns();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunctionSymbol getJsToKotlinAnyAdapter() {
        return this.symbols.getJsRelatedSymbols().getJsInteropAdapters().getJsToKotlinAnyAdapter();
    }

    private final IrSimpleFunctionSymbol getKotlinToJsAnyAdapter() {
        return this.symbols.getJsRelatedSymbols().getJsInteropAdapters().getKotlinToJsAnyAdapter();
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitTypeOperator(expression2);
        BackendContext backendContext = this.context;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull(scopeWithIr);
        this.builder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null), expression2);
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                irExpression = this.lowerImplicitCast(expression2);
                break;
            }
            case 2: {
                throw new IllegalStateException("Dynamic casts are not supported in Wasm backend".toString());
            }
            case 3: {
                irExpression = expression2;
                break;
            }
            case 4: {
                irExpression = this.lowerIntegerCoercion(expression2);
                break;
            }
            case 5: {
                irExpression = this.lowerImplicitCast(expression2);
                break;
            }
            case 6: {
                irExpression = this.lowerInstanceOf(expression2, false);
                break;
            }
            case 7: {
                irExpression = this.lowerInstanceOf(expression2, true);
                break;
            }
            case 8: {
                irExpression = this.lowerCast(expression2, false);
                break;
            }
            case 9: {
                irExpression = this.lowerCast(expression2, true);
                break;
            }
            case 10: {
                String string2 = "SAM conversion: " + RenderIrElementKt.render$default(expression2, null, 1, null);
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
            case 11: {
                irExpression = expression2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrExpression initializer2 = declaration.getInitializer();
        if (initializer2 != null && !Intrinsics.areEqual(initializer2.getType(), declaration.getType())) {
            BackendContext backendContext = this.context;
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull(scopeWithIr);
            this.builder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null), declaration);
            declaration.setInitializer(this.narrowType(initializer2.getType(), declaration.getType(), initializer2));
        }
        return super.visitVariable(declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerInstanceOf(IrTypeOperatorCall expression2, boolean inverted) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrBuilderWithScope irBuilderWithScope = declarationIrBuilder;
        IrType resultType$iv = this.builtIns.getBooleanType();
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$lowerInstanceOf_u24lambda_u240 = this_$iv$iv;
        boolean bl = false;
        Function0<IrExpression> argument2 = this.cacheValue((IrBlockBuilder)$this$lowerInstanceOf_u24lambda_u240, expression2.getArgument());
        IrExpression check2 = this.generateTypeCheck(argument2, expression2.getTypeOperand());
        if (inverted) {
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder2 = null;
            }
            $this$lowerInstanceOf_u24lambda_u240.unaryPlus(LowerUtilsKt.irNot(declarationIrBuilder2, check2));
        } else {
            $this$lowerInstanceOf_u24lambda_u240.unaryPlus(check2);
        }
        return this_$iv$iv.doBuild();
    }

    private final Function0<IrExpression> cacheValue(IrBlockBuilder $this$cacheValue, IrExpression value2) {
        if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default(value2, true, false, null, 6, null) && IrUtilsKt.isTrivial(value2)) {
            return new Function0<IrExpression>(value2){
                final /* synthetic */ IrExpression $value;
                {
                    this.$value = $value;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final IrExpression invoke() {
                    void p1;
                    DeepCopyTypeRemapper typeRemapper$iv$iv;
                    void $this$deepCopyWithSymbols$iv$iv;
                    IrElement $this$deepCopyWithSymbols_u24default$iv = this.$value;
                    IrDeclarationParent initialParent$iv = null;
                    boolean $i$f$deepCopyWithSymbols = false;
                    IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
                    DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                    boolean $i$f$deepCopyWithSymbols2 = false;
                    IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
                    TypeRemapper typeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                    DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                    void var11_10 = $this$deepCopyWithSymbols$iv$iv;
                    boolean bl = false;
                    typeRemapper = typeRemapper;
                    SymbolRemapper p0 = deepCopySymbolRemapper;
                    IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var11_10.transform(new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1), null), initialParent$iv);
                    if (irElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    }
                    return (IrExpression)((IrElement)((IrExpression)irElement2));
                }
            };
        }
        IrVariable tmpVal = IrBuilderKt.createTmpVariable$default($this$cacheValue, value2, null, false, null, null, 30, null);
        return new Function0<IrGetValueImpl>(this, tmpVal){
            final /* synthetic */ WasmBaseTypeOperatorTransformer this$0;
            final /* synthetic */ IrVariable $tmpVal;
            {
                this.this$0 = $receiver;
                this.$tmpVal = $tmpVal;
                super(0);
            }

            @NotNull
            public final IrGetValueImpl invoke() {
                DeclarationIrBuilder declarationIrBuilder = WasmBaseTypeOperatorTransformer.access$getBuilder$p(this.this$0);
                if (declarationIrBuilder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("builder");
                    declarationIrBuilder = null;
                }
                return ExpressionHelpersKt.irGet(declarationIrBuilder, this.$tmpVal);
            }
        };
    }

    private final boolean isInlined(IrType $this$isInlined) {
        return this.context.getInlineClassesUtils().isTypeInlined($this$isInlined);
    }

    private final IrClass getEraseToClassOrInterface(IrType $this$eraseToClassOrInterface) {
        IrClass irClass2 = TypeTranformerKt.getErasedUpperBound($this$eraseToClassOrInterface);
        if (irClass2 == null) {
            irClass2 = (IrClass)this.builtIns.getAnyClass().getOwner();
        }
        return irClass2;
    }

    private final IrExpression generateTypeCheck(Function0<? extends IrExpression> valueProvider, IrType toType) {
        IrExpression irExpression;
        IrType toNotNullable = IrTypesKt.makeNotNull(toType);
        IrExpression valueInstance = valueProvider.invoke();
        IrType fromType = valueInstance.getType();
        if (this.isInlined(fromType)) {
            boolean result2 = IrUtilsKt.isSubclassOf(this.getEraseToClassOrInterface(fromType), this.getEraseToClassOrInterface(toType));
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            return ExpressionHelpersKt.irBoolean(declarationIrBuilder, result2);
        }
        IrExpression instanceCheck = this.generateTypeCheckNonNull(valueInstance, toNotNullable);
        boolean isFromNullable = IrTypeUtilsKt.isNullable(valueInstance.getType());
        boolean isToNullable = IrTypeUtilsKt.isNullable(toType);
        if (!isFromNullable) {
            irExpression = instanceCheck;
        } else {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope irBuilderWithScope = declarationIrBuilder;
            IrType irType = this.builtIns.getBooleanType();
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder2 = null;
            }
            IrExpression irExpression2 = ExpressionHelpersKt.irEqualsNull(declarationIrBuilder2, valueProvider.invoke());
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder3 = null;
            }
            irExpression = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope, irType, irExpression2, ExpressionHelpersKt.irBoolean(declarationIrBuilder3, isToNullable), instanceCheck, null, 16, null);
        }
        return irExpression;
    }

    private final IrExpression lowerIntegerCoercion(IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        IrType irType = expression2.getTypeOperand();
        if (Intrinsics.areEqual(irType, this.builtIns.getByteType()) ? true : Intrinsics.areEqual(irType, this.builtIns.getShortType())) {
            irExpression = expression2.getArgument();
        } else if (Intrinsics.areEqual(irType, this.builtIns.getLongType())) {
            IrCall irCall;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrCall $this$lowerIntegerCoercion_u24lambda_u241 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getIntToLong());
            boolean bl = false;
            $this$lowerIntegerCoercion_u24lambda_u241.putValueArgument(0, expression2.getArgument());
            irExpression = irCall;
        } else {
            throw new IllegalStateException("Unreachable execution (coercion to non-Integer type".toString());
        }
        return irExpression;
    }

    private final IrExpression generateTypeCheckNonNull(IrExpression argument2, IrType toType) {
        IrExpression irExpression;
        boolean bl;
        boolean bl2 = bl = !IrTypePredicatesKt.isMarkedNullable(toType);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        IrClass classOrInterface = this.getEraseToClassOrInterface(toType);
        if (classOrInterface.isExternal()) {
            if (classOrInterface.getKind() == ClassKind.INTERFACE) {
                DeclarationIrBuilder declarationIrBuilder = this.builder;
                if (declarationIrBuilder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("builder");
                    declarationIrBuilder = null;
                }
                irExpression = ExpressionHelpersKt.irTrue(declarationIrBuilder);
            } else {
                irExpression = this.generateIsExternalClass(argument2, classOrInterface);
            }
        } else if (IrTypePredicatesKt.isNothing(toType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            irExpression = ExpressionHelpersKt.irFalse(declarationIrBuilder);
        } else {
            irExpression = org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isTypeParameter(toType) ? this.generateTypeCheckWithTypeParameter(argument2, toType) : (org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isInterface(toType) ? this.generateIsInterface(argument2, toType) : this.generateIsSubClass(argument2, toType));
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression narrowType(IrType fromType, IrType toType, IrExpression value2) {
        IrCall irCall;
        if (Intrinsics.areEqual(fromType, toType)) {
            return value2;
        }
        if (Intrinsics.areEqual(toType, this.builtIns.getNothingNType())) {
            void this_$iv$iv;
            void $this$irComposite_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope irBuilderWithScope = declarationIrBuilder;
            IrType resultType$iv = this.builtIns.getNothingNType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$narrowType_u24lambda_u242 = this_$iv$iv;
            boolean bl = false;
            $this$narrowType_u24lambda_u242.unaryPlus(value2);
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder2 = null;
            }
            $this$narrowType_u24lambda_u242.unaryPlus(ExpressionHelpersKt.irNull(declarationIrBuilder2));
            return this_$iv$iv.doBuild();
        }
        if (Intrinsics.areEqual(toType, this.builtIns.getAnyNType()) && Intrinsics.areEqual(fromType, this.builtIns.getNothingNType()) && value2 instanceof IrConst && Intrinsics.areEqual(((IrConst)value2).getKind(), IrConstKind.Null.INSTANCE)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            return ExpressionHelpersKt.irNull(declarationIrBuilder, this.builtIns.getNothingNType());
        }
        if (this.isInlined(toType) && !this.isInlined(fromType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            Object $this$irComposite_u24default$iv = new IrType[]{fromType, toType};
            Object it = $this$irComposite_u24default$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getUnboxIntrinsic(), toType, CollectionsKt.listOf($this$irComposite_u24default$iv));
            boolean bl = false;
            ((IrMemberAccessExpression)it).putValueArgument(0, value2);
            return (IrExpression)$this$irComposite_u24default$iv;
        }
        if (!this.isInlined(toType) && this.isInlined(fromType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            Object $this$irComposite_u24default$iv = new IrType[]{fromType, toType};
            Object it = $this$irComposite_u24default$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getBoxIntrinsic(), toType, CollectionsKt.listOf($this$irComposite_u24default$iv));
            boolean bl = false;
            ((IrMemberAccessExpression)it).putValueArgument(0, value2);
            return (IrExpression)$this$irComposite_u24default$iv;
        }
        IrClass fromClass = this.getEraseToClassOrInterface(fromType);
        IrClass toClass = this.getEraseToClassOrInterface(toType);
        if (fromClass.isExternal() && toClass.isExternal()) {
            return value2;
        }
        if (IrUtilsKt.isNullConst(value2) && fromClass.isExternal() != toClass.isExternal()) {
            value2.setType(toType);
            return value2;
        }
        if (fromClass.isExternal() && !toClass.isExternal()) {
            IrCall origin$iv;
            if (this.context.getConfiguration().get(JSConfigurationKeys.WASM_TARGET, WasmTarget.JS) == WasmTarget.WASI) {
                String bl = "Implement externalize adapter for wasi mode";
                throw new NotImplementedError("An operation is not implemented: " + bl);
            }
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrCall it = origin$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.getJsToKotlinAnyAdapter());
            boolean bl = false;
            it.putValueArgument(0, value2);
            IrCall narrowingToAny2 = origin$iv;
            return this.narrowType(this.context.getIrBuiltIns().getAnyType(), toType, narrowingToAny2);
        }
        if (toClass.isExternal() && !fromClass.isExternal()) {
            IrCall narrowingToAny2;
            if (this.context.getConfiguration().get(JSConfigurationKeys.WASM_TARGET, WasmTarget.JS) == WasmTarget.WASI) {
                String narrowingToAny2 = "Implement internalize adapter for wasi mode";
                throw new NotImplementedError("An operation is not implemented: " + narrowingToAny2);
            }
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrCall it = narrowingToAny2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.getKotlinToJsAnyAdapter());
            boolean bl = false;
            it.putValueArgument(0, value2);
            return narrowingToAny2;
        }
        if (IrUtilsKt.isSubclassOf(fromClass, toClass)) {
            return value2;
        }
        if (IrTypePredicatesKt.isNothing(toType)) {
            void this_$iv$iv;
            void $this$irComposite_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope narrowingToAny2 = declarationIrBuilder;
            IrType resultType$iv = this.context.getIrBuiltIns().getNothingType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder $this$narrowType_u24lambda_u242 = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$narrowType_u24lambda_u247 = this_$iv$iv;
            boolean bl = false;
            $this$narrowType_u24lambda_u247.unaryPlus(value2);
            $this$narrowType_u24lambda_u247.unaryPlus(ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$narrowType_u24lambda_u247, this.symbols.getWasmUnreachable()));
            return this_$iv$iv.doBuild();
        }
        if (Intrinsics.areEqual(toType, this.symbols.getVoidType())) {
            IrCall irCall2;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrCall $this$narrowType_u24lambda_u248 = irCall2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.findVoidConsumer(value2.getType()));
            boolean bl = false;
            $this$narrowType_u24lambda_u248.putValueArgument(0, value2);
            return irCall2;
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrCall $this$narrowType_u24lambda_u249 = irCall = ExpressionHelpersKt.irCall$default(declarationIrBuilder, this.symbols.getRefCastNull(), toType, 0, 0, null, 28, null);
        boolean bl = false;
        $this$narrowType_u24lambda_u249.putTypeArgument(0, toType);
        $this$narrowType_u24lambda_u249.putValueArgument(0, value2);
        return irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerCast(IrTypeOperatorCall expression2, boolean isSafe) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        DeclarationIrBuilder declarationIrBuilder;
        IrExpression failResult;
        IrExpression irExpression;
        IrType toType = expression2.getTypeOperand();
        IrType fromType = expression2.getArgument().getType();
        if (IrUtilsKt.isSubclassOf(this.getEraseToClassOrInterface(fromType), this.getEraseToClassOrInterface(expression2.getType()))) {
            return this.narrowType(fromType, expression2.getType(), expression2.getArgument());
        }
        if (isSafe) {
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder2 = null;
            }
            irExpression = ExpressionHelpersKt.irNull(declarationIrBuilder2);
        } else {
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder3 = null;
            }
            irExpression = failResult = (IrExpression)ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder3, this.context.getIr().getSymbols().getThrowTypeCastException());
        }
        if ((declarationIrBuilder = this.builder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrBuilderWithScope irBuilderWithScope = declarationIrBuilder;
        IrType resultType$iv = expression2.getType();
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$lowerCast_u24lambda_u2410 = this_$iv$iv;
        boolean bl = false;
        Function0<IrExpression> argument2 = this.cacheValue((IrBlockBuilder)$this$lowerCast_u24lambda_u2410, expression2.getArgument());
        IrExpression narrowArg = this.narrowType(fromType, expression2.getType(), argument2.invoke());
        IrExpression check2 = this.generateTypeCheck(argument2, toType);
        if (check2 instanceof IrConst) {
            Object t = ((IrConst)check2).getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Boolean");
            boolean value2 = (Boolean)t;
            if (value2) {
                $this$lowerCast_u24lambda_u2410.unaryPlus(narrowArg);
            } else {
                $this$lowerCast_u24lambda_u2410.unaryPlus(failResult);
            }
        } else {
            DeclarationIrBuilder declarationIrBuilder4 = this.builder;
            if (declarationIrBuilder4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder4 = null;
            }
            $this$lowerCast_u24lambda_u2410.unaryPlus(ExpressionHelpersKt.irIfThenElse$default(declarationIrBuilder4, expression2.getType(), check2, narrowArg, failResult, null, 16, null));
        }
        return this_$iv$iv.doBuild();
    }

    private final IrExpression lowerImplicitCast(IrTypeOperatorCall expression2) {
        return this.narrowType(expression2.getArgument().getType(), expression2.getTypeOperand(), expression2.getArgument());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateTypeCheckWithTypeParameter(IrExpression argument2, IrType toType) {
        void $this$fold$iv;
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(toType);
        IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        IrTypeParameter irTypeParameter2 = irSymbolOwner instanceof IrTypeParameter ? (IrTypeParameter)irSymbolOwner : null;
        if (irTypeParameter2 == null) {
            throw new IllegalStateException(("expected type parameter, but got " + toType).toString());
        }
        IrTypeParameter typeParameter2 = irTypeParameter2;
        Iterable iterable = typeParameter2.getSuperTypes();
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrConstImpl<Boolean> irConstImpl = ExpressionHelpersKt.irTrue(declarationIrBuilder);
        Intrinsics.checkNotNull(irConstImpl, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        IrExpression initial$iv = irConstImpl;
        boolean $i$f$fold = false;
        IrExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            IrCall irCall;
            void t;
            IrType irType = (IrType)element$iv;
            IrExpression r = accumulator$iv;
            boolean bl = false;
            IrExpression check2 = this.generateTypeCheckNonNull(IrUtilsKt.shallowCopy(argument2), IrTypesKt.makeNotNull((IrType)t));
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder2 = null;
            }
            IrCall $this$generateTypeCheckWithTypeParameter_u24lambda_u2412_u24lambda_u2411 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder2, this.symbols.getBooleanAnd());
            boolean bl2 = false;
            $this$generateTypeCheckWithTypeParameter_u24lambda_u2412_u24lambda_u2411.putValueArgument(0, r);
            $this$generateTypeCheckWithTypeParameter_u24lambda_u2412_u24lambda_u2411.putValueArgument(1, check2);
            accumulator$iv = irCall;
        }
        return accumulator$iv;
    }

    private final IrExpression generateIsInterface(IrExpression argument2, IrType toType) {
        IrCall irCall;
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrCall $this$generateIsInterface_u24lambda_u2413 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getWasmIsInterface());
        boolean bl = false;
        $this$generateIsInterface_u24lambda_u2413.putValueArgument(0, argument2);
        $this$generateIsInterface_u24lambda_u2413.putTypeArgument(0, toType);
        return irCall;
    }

    private final IrExpression generateIsSubClass(IrExpression argument2, IrType toType) {
        IrCall irCall;
        IrClass toTypeErased;
        IrType fromType = argument2.getType();
        IrClass fromTypeErased = TypeTransformerKt.getRuntimeClass(fromType, this.context.getIrBuiltIns());
        if (IrUtilsKt.isSubclassOf(fromTypeErased, toTypeErased = TypeTransformerKt.getRuntimeClass(toType, this.context.getIrBuiltIns()))) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            return ExpressionHelpersKt.irTrue(declarationIrBuilder);
        }
        if (!IrUtilsKt.isSubclassOf(toTypeErased, fromTypeErased)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            return ExpressionHelpersKt.irFalse(declarationIrBuilder);
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrCall $this$generateIsSubClass_u24lambda_u2414 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getRefTest());
        boolean bl = false;
        $this$generateIsSubClass_u24lambda_u2414.putValueArgument(0, argument2);
        $this$generateIsSubClass_u24lambda_u2414.putTypeArgument(0, toType);
        return irCall;
    }

    private final IrExpression generateIsExternalClass(IrExpression argument2, IrClass klass) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        DeclarationIrBuilder declarationIrBuilder;
        IrSimpleFunction wrappedInstanceCheckIfAny;
        IrSimpleFunction irSimpleFunction = this.context.getMapping().getWasmExternalClassToInstanceCheck().get((IrClass)((IrDeclaration)klass));
        Intrinsics.checkNotNull(irSimpleFunction);
        IrSimpleFunction instanceCheckFunction = irSimpleFunction;
        IrSimpleFunction irSimpleFunction2 = this.context.getMapping().getWasmJsInteropFunctionToWrapper().get((IrSimpleFunction)((IrDeclaration)instanceCheckFunction));
        if (irSimpleFunction2 == null) {
            irSimpleFunction2 = wrappedInstanceCheckIfAny = instanceCheckFunction;
        }
        if ((declarationIrBuilder = this.builder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrFunctionAccessExpression it = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, wrappedInstanceCheckIfAny);
        boolean bl = false;
        it.putValueArgument(0, this.narrowType(argument2.getType(), this.context.getIrBuiltIns().getAnyType(), argument2));
        return irFunctionAccessExpression;
    }

    public static final /* synthetic */ DeclarationIrBuilder access$getBuilder$p(WasmBaseTypeOperatorTransformer $this) {
        return $this.builder;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_DYNAMIC_CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_INTEGER_COERCION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

