export class FileSet extends EventEmitter {
  /**
   * FileSet constructor.
   * A FileSet is created to process multiple files through unified processors.
   * This set, containing all files, is exposed to plugins as an argument to the
   * attacher.
   */
  constructor()
  /** @type {Array<VFile>} */
  files: Array<VFile>
  /** @type {Array<string>} */
  origins: Array<string>
  /** @type {Array<Completer>} */
  plugins: Array<Completer>
  /** @type {number} */
  expected: number
  /** @type {number} */
  actual: number
  /** @type {Pipeline} */
  pipeline: Pipeline
  /**
   * Access the files in a set.
   */
  valueOf(): import('vfile').VFile[]
  /**
   * Attach middleware to the pipeline on `fileSet`.
   *
   * @param {Completer} plugin
   */
  use(plugin: Completer): FileSet
  /**
   * Add a file to be processed.
   * The given file is processed like other files with a few differences:
   *
   * *   Ignored when their file path is already added
   * *   Never written to the file system or streamOut
   * *   Not reported for
   *
   * @param {string|VFile} file
   */
  add(file: string | VFile): FileSet
}
export type VFile = import('vfile').VFile
export type Pipeline = import('trough').Pipeline
export type CompleterCallback = (
  set: FileSet,
  callback: (error?: Error | null) => void
) => void
export type CompleterAsync = (set: FileSet) => Promise<void>
export type CompleterSync = (set: FileSet) => void
export type Completer = (CompleterCallback | CompleterAsync | CompleterSync) & {
  pluginId?: string
}
import {EventEmitter} from 'events'
