/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.test;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.test.MockDirectory;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class DirectoryTest
extends TestCase {
    public DirectoryTest(String s) {
        super(s);
    }

    public void testSetAndGetInt() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(MockDirectory.class);
        int value = 321;
        int tagType = 123;
        directory.setInt(tagType, value);
        DirectoryTest.assertEquals((int)value, (int)directory.getInt(tagType));
        DirectoryTest.assertEquals((String)Integer.toString(value), (String)directory.getString(tagType));
    }

    public void testSetAndGetIntArray() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(MockDirectory.class);
        int[] inputValues = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        int tagType = 123;
        directory.setIntArray(tagType, inputValues);
        int[] outputValues = directory.getIntArray(tagType);
        DirectoryTest.assertEquals((int)inputValues.length, (int)outputValues.length);
        int i = 0;
        while (i < inputValues.length) {
            int inputValue = inputValues[i];
            int outputValue = outputValues[i];
            DirectoryTest.assertEquals((int)inputValue, (int)outputValue);
            ++i;
        }
        DirectoryTest.assertEquals((Object)inputValues, (Object)directory.getIntArray(tagType));
        StringBuffer outputString = new StringBuffer();
        int i2 = 0;
        while (i2 < inputValues.length) {
            int inputValue = inputValues[i2];
            if (i2 > 0) {
                outputString.append(' ');
            }
            outputString.append(inputValue);
            ++i2;
        }
        DirectoryTest.assertEquals((String)outputString.toString(), (String)directory.getString(tagType));
    }

    public void testSetStringAndGetDate() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(MockDirectory.class);
        String date1 = "2002:01:30 24:59:59";
        String date2 = "2002:01:30 24:59";
        String date3 = "2002-01-30 24:59:59";
        String date4 = "2002-01-30 24:59";
        directory.setString(1, date1);
        directory.setString(2, date2);
        directory.setString(3, date3);
        directory.setString(4, date4);
        DirectoryTest.assertEquals((String)date1, (String)directory.getString(1));
        DirectoryTest.assertEquals((Object)new GregorianCalendar(2002, 0, 30, 24, 59, 59).getTime(), (Object)directory.getDate(1));
        DirectoryTest.assertEquals((Object)new GregorianCalendar(2002, 0, 30, 24, 59, 0).getTime(), (Object)directory.getDate(2));
        DirectoryTest.assertEquals((Object)new GregorianCalendar(2002, 0, 30, 24, 59, 59).getTime(), (Object)directory.getDate(3));
        DirectoryTest.assertEquals((Object)new GregorianCalendar(2002, 0, 30, 24, 59, 0).getTime(), (Object)directory.getDate(4));
    }

    public void testSetIntArrayGetByteArray() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(MockDirectory.class);
        int[] ints = new int[]{1, 2, 3, 4, 5};
        directory.setIntArray(1, ints);
        DirectoryTest.assertEquals((int)ints.length, (int)directory.getByteArray(1).length);
        DirectoryTest.assertEquals((int)1, (int)directory.getByteArray(1)[0]);
    }

    public void testSetStringGetInt() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(MockDirectory.class);
        byte[] bytes = new byte[]{1, 2, 3};
        directory.setString(1, new String(bytes));
        DirectoryTest.assertEquals((int)66051, (int)directory.getInt(1));
    }
}

