/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.animation.Animation;
import net.sf.freecol.client.gui.animation.UnitImageAnimation;
import net.sf.freecol.client.gui.animation.UnitMoveAnimation;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class Animations {
    private static final Logger logger = Logger.getLogger(Animations.class.getName());

    public static List<Animation> unitMove(FreeColClient freeColClient, Unit unit, Tile source, Tile destination, float scale) {
        ArrayList<Animation> ret = new ArrayList<Animation>();
        int speed = freeColClient.getAnimationSpeed(unit.getOwner());
        if (speed > 0) {
            UnitMoveAnimation a = new UnitMoveAnimation(unit, source, destination, speed, scale);
            if (a == null) {
                logger.warning("No move animation for: " + unit);
            } else {
                ret.add(a);
            }
        }
        return ret;
    }

    private static String getAttackAnimationBase(Unit unit) {
        String roleStr = unit.hasDefaultRole() ? "" : "." + unit.getRoleSuffix();
        return "animation.unit." + unit.getType().getId() + roleStr + ".attack.";
    }

    public static List<Animation> unitAttack(FreeColClient freeColClient, Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success, float scale) {
        ArrayList<Animation> ret = new ArrayList<Animation>();
        Direction dirn = attackerTile.getDirection(defenderTile);
        if (dirn == null) {
            logger.warning("Attack animation null direction: " + attacker + " v " + defender);
            return ret;
        }
        if (freeColClient.getAnimationSpeed(attacker.getOwner()) > 0) {
            UnitImageAnimation a = UnitImageAnimation.build(attacker, attackerTile, dirn, Animations.getAttackAnimationBase(attacker), scale);
            if (a == null) {
                logger.warning("No attack animation for: " + attacker + " (" + dirn + ")");
            } else {
                ret.add(a);
            }
        }
        if (!success && freeColClient.getAnimationSpeed(defender.getOwner()) > 0) {
            Direction revd = dirn.getReverseDirection();
            UnitImageAnimation a = UnitImageAnimation.build(defender, defenderTile, revd, Animations.getAttackAnimationBase(defender), scale);
            if (a == null) {
                logger.warning("No attack animation for: " + defender + " (" + revd + ")");
            } else {
                ret.add(a);
            }
        }
        return ret;
    }

    public static interface Procedure {
        public void execute();
    }
}

